/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import net.biorfn.compressedfurnace.CompressedFurnace;
import net.biorfn.compressedfurnace.blocks.AbstractCompressedBlock;
import net.biorfn.compressedfurnace.config.Config;
import net.biorfn.compressedfurnace.util.entitiy.BurnUtil;
import net.biorfn.compressedfurnace.util.entitiy.CookingState;
import net.biorfn.compressedfurnace.util.entitiy.ExtraItemManager;
import net.biorfn.compressedfurnace.util.entitiy.SideConfigHelper;
import net.biorfn.compressedfurnace.util.entitiy.SlotManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCompressedEntityBlock
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible {
    public String tierID;
    private static final int FUEL = 0;
    private static final int INPUT0 = 1;
    private static final int INPUT1 = 3;
    private static final int INPUT2 = 5;
    private static final int INPUT3 = 7;
    private static final int INPUT4 = 9;
    private static final int INPUT5 = 11;
    private static final int[] INPUTSLOTS = new int[]{1, 3, 5, 7, 9, 11};
    protected boolean autoSplitEnabled = false;
    protected boolean hasUnclaimedXP = false;
    protected boolean isExport = false;
    protected int trackedSlotForXP = -1;
    protected int[] SLOTS_FOR_DOWN;
    protected int[] SLOTS_FOR_SIDES;
    public int[] SLOTS_FOR_INPUT;
    protected int[] SLOTS_FOR_OUTPUT;
    private final SideConfigHelper sideConfigHelper;
    public final int DEFAULT_COOK_TIME;
    protected final RecipeType<? extends AbstractCookingRecipe> recipeType;
    public NonNullList<ItemStack> items;
    int litTime;
    int litDuration;
    protected ContainerData dataAccess;
    protected final ContainerData dataAccess1;
    protected final Object2IntOpenHashMap<ResourceLocation> recipesUsed;
    protected final Map<Integer, Object2IntOpenHashMap<ResourceLocation>> recipesUsedPerSlot;
    protected final RecipeManager.CachedCheck<SingleRecipeInput, ? extends AbstractCookingRecipe> quickCheck;
    protected final Map<Integer, CookingState> cookingStateBySlot = new HashMap<Integer, CookingState>();
    protected final Map<Integer, Integer> fuelTicksBySlot = new HashMap<Integer, Integer>();
    private int fuelPool;
    private boolean isVisualShift = false;
    protected final ExtraItemManager extraItemManager = new ExtraItemManager();
    protected final String type;
    private long lastTransferTime = 0L;
    protected final Map<Integer, ItemStack> inputToAllowedItemsMap = new HashMap<Integer, ItemStack>();

    public AbstractCompressedEntityBlock(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state, String tierId, RecipeType<? extends AbstractCookingRecipe> recipeType, String type) {
        super(tileEntityTypeIn, pos, state);
        this.tierID = tierId;
        this.recipesUsedPerSlot = new HashMap<Integer, Object2IntOpenHashMap<ResourceLocation>>();
        this.items = NonNullList.withSize((int)13, (Object)ItemStack.EMPTY);
        this.SLOTS_FOR_DOWN = IntStream.concat(Arrays.stream(this.assignSlots(tierId, false)), IntStream.of(0)).toArray();
        this.SLOTS_FOR_SIDES = new int[]{0};
        this.SLOTS_FOR_INPUT = this.assignSlots(tierId, true);
        this.SLOTS_FOR_OUTPUT = this.assignSlots(tierId, false);
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        this.sideConfigHelper = new SideConfigHelper(facing);
        this.recipeType = recipeType;
        this.type = type;
        this.DEFAULT_COOK_TIME = type.equals("blast") ? 100 : 200;
        this.dataAccess1 = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> {
                        if (AbstractCompressedEntityBlock.this.autoSplitEnabled) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 1 -> {
                        if (AbstractCompressedEntityBlock.this.hasUnclaimedXP) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 2 -> AbstractCompressedEntityBlock.this.sideTypeToIndex(Direction.UP);
                    case 3 -> AbstractCompressedEntityBlock.this.sideTypeToIndex(Direction.DOWN);
                    case 4 -> AbstractCompressedEntityBlock.this.sideTypeToIndex(Direction.NORTH);
                    case 5 -> AbstractCompressedEntityBlock.this.sideTypeToIndex(Direction.SOUTH);
                    case 6 -> AbstractCompressedEntityBlock.this.sideTypeToIndex(Direction.EAST);
                    case 7 -> AbstractCompressedEntityBlock.this.sideTypeToIndex(Direction.WEST);
                    case 8 -> {
                        if (AbstractCompressedEntityBlock.this.isExport) {
                            yield 1;
                        }
                        yield 0;
                    }
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        AbstractCompressedEntityBlock.this.autoSplitEnabled = value == 1;
                    }
                    case 1: {
                        AbstractCompressedEntityBlock.this.hasUnclaimedXP = value == 1;
                    }
                    case 2: {
                        AbstractCompressedEntityBlock.this.setSlotType(Direction.UP, value);
                    }
                    case 3: {
                        AbstractCompressedEntityBlock.this.setSlotType(Direction.DOWN, value);
                    }
                    case 4: {
                        AbstractCompressedEntityBlock.this.setSlotType(Direction.NORTH, value);
                    }
                    case 5: {
                        AbstractCompressedEntityBlock.this.setSlotType(Direction.SOUTH, value);
                    }
                    case 6: {
                        AbstractCompressedEntityBlock.this.setSlotType(Direction.EAST, value);
                    }
                    case 7: {
                        AbstractCompressedEntityBlock.this.setSlotType(Direction.WEST, value);
                    }
                    case 8: {
                        AbstractCompressedEntityBlock.this.isExport = value == 1;
                    }
                }
            }

            public int getCount() {
                return 9;
            }
        };
        this.dataAccess = new ContainerData(){

            public int get(int index) {
                boolean isProgress;
                switch (index) {
                    case 0: {
                        return AbstractCompressedEntityBlock.this.litTime;
                    }
                    case 1: {
                        return AbstractCompressedEntityBlock.this.litDuration;
                    }
                }
                int slotIndex = (index - 2) / 2;
                boolean bl = isProgress = index % 2 == 0;
                if (slotIndex >= 0 && slotIndex < INPUTSLOTS.length) {
                    CookingState state = AbstractCompressedEntityBlock.this.cookingStateBySlot.get(INPUTSLOTS[slotIndex]);
                    return state != null ? (isProgress ? state.getProgress() : state.getTotalTime()) : 0;
                }
                return 0;
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        AbstractCompressedEntityBlock.this.litTime = value;
                        break;
                    }
                    case 1: {
                        AbstractCompressedEntityBlock.this.litDuration = value;
                        break;
                    }
                    default: {
                        boolean isProgress;
                        int slotIndex = (index - 2) / 2;
                        boolean bl = isProgress = index % 2 == 0;
                        if (slotIndex < 0 || slotIndex >= INPUTSLOTS.length) break;
                        CookingState state = AbstractCompressedEntityBlock.this.cookingStateBySlot.computeIfAbsent(INPUTSLOTS[slotIndex], key -> new CookingState(0, AbstractCompressedEntityBlock.this.DEFAULT_COOK_TIME));
                        if (isProgress) {
                            state.setProgress(value);
                            break;
                        }
                        state.setTotalTime(value);
                    }
                }
            }

            public int getCount() {
                return 2 + 2 * INPUTSLOTS.length;
            }
        };
        this.recipesUsed = new Object2IntOpenHashMap();
        this.quickCheck = RecipeManager.createCheck(recipeType);
        for (int inputSlot : INPUTSLOTS) {
            this.cookingStateBySlot.put(inputSlot, CookingState.createWithTier(tierId, this.DEFAULT_COOK_TIME));
            this.fuelTicksBySlot.put(inputSlot, 0);
        }
    }

    protected int sideTypeToIndex(Direction side) {
        return this.sideConfigHelper.sideTypeToIndex(side);
    }

    protected void setSlotType(Direction side, int index) {
        this.sideConfigHelper.setSlotType(side, index);
    }

    protected boolean isLit() {
        return this.litTime > 0;
    }

    public boolean isAutoSplitEnabled() {
        return this.autoSplitEnabled;
    }

    public void setAutoSplitEnabled(boolean enabled) {
        this.autoSplitEnabled = enabled;
    }

    public void toggleAutoSplit() {
        this.setAutoSplitEnabled(!this.isAutoSplitEnabled());
        this.setChanged();
    }

    public boolean isHasUnclaimedXP() {
        return this.hasUnclaimedXP;
    }

    public void setHasUnclaimedXP(boolean hasUnclaimedXP) {
        this.hasUnclaimedXP = hasUnclaimedXP;
    }

    protected boolean isCursher() {
        return this.type.equals("crusher");
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.tierID = tag.getString("TierID");
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        this.litTime = tag.getInt("LitTime");
        this.litDuration = this.getBurnDuration((ItemStack)this.items.get(1));
        this.SLOTS_FOR_DOWN = IntStream.concat(Arrays.stream(this.assignSlots(this.tierID, false)), IntStream.of(0)).toArray();
        this.SLOTS_FOR_SIDES = new int[]{0};
        this.SLOTS_FOR_INPUT = this.assignSlots(this.tierID, true);
        this.SLOTS_FOR_OUTPUT = this.assignSlots(this.tierID, false);
        this.fuelPool = tag.contains("FuelPool") ? tag.getInt("FuelPool") : tag.getInt("LitTime");
        this.setAutoSplitEnabled(tag.getBoolean("AutoSplitEnabled"));
        this.setHasUnclaimedXP(tag.getBoolean("HasUnclaimedXP"));
        this.setAutoExport(tag.getBoolean("AutoExport"));
        CompoundTag fuelTicksBySlotTag = tag.getCompound("FuelTicksBySlot");
        for (String key : fuelTicksBySlotTag.getAllKeys()) {
            int slot = Integer.parseInt(key);
            this.fuelTicksBySlot.put(slot, fuelTicksBySlotTag.getInt(key));
        }
        this.loadCookingState(tag);
        this.recipesUsedPerSlot.clear();
        CompoundTag recipesUsedPerSlotTag = tag.getCompound("RecipesUsedPerSlot");
        for (String slotKey : recipesUsedPerSlotTag.getAllKeys()) {
            int slot = Integer.parseInt(slotKey);
            CompoundTag slotRecipesTag = recipesUsedPerSlotTag.getCompound(slotKey);
            Object2IntOpenHashMap recipes = new Object2IntOpenHashMap();
            for (String recipeKey : slotRecipesTag.getAllKeys()) {
                recipes.put((Object)ResourceLocation.tryParse((String)recipeKey), slotRecipesTag.getInt(recipeKey));
            }
            this.recipesUsedPerSlot.put(slot, (Object2IntOpenHashMap<ResourceLocation>)recipes);
        }
        this.loadSide(tag);
    }

    protected void loadCookingState(CompoundTag tag) {
        CompoundTag cookingStateTag = tag.getCompound("CookingStateBySlot");
        for (String key : cookingStateTag.getAllKeys()) {
            int slot = Integer.parseInt(key);
            CompoundTag stateTag = cookingStateTag.getCompound(key);
            this.cookingStateBySlot.put(slot, new CookingState(stateTag.getInt("Progress"), stateTag.getInt("TotalTime")));
        }
    }

    protected void loadSide(CompoundTag tag) {
        this.sideConfigHelper.loadFromNBT(tag);
    }

    protected void saveSide(CompoundTag tag) {
        this.sideConfigHelper.saveToNBT(tag);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putString("TierID", this.tierID);
        tag.putInt("LitTime", this.litTime);
        tag.putInt("LitDuration", this.litDuration);
        tag.putBoolean("AutoSplitEnabled", this.autoSplitEnabled);
        tag.putBoolean("HasUnclaimedXP", this.hasUnclaimedXP);
        tag.putBoolean("AutoExport", this.isExport);
        tag.putInt("FuelPool", this.fuelPool);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        CompoundTag fuelTicksBySlotTag = new CompoundTag();
        for (Map.Entry<Integer, Integer> entry : this.fuelTicksBySlot.entrySet()) {
            fuelTicksBySlotTag.putInt(entry.getKey().toString(), entry.getValue().intValue());
        }
        CompoundTag cookingStateTag = new CompoundTag();
        for (Map.Entry<Integer, CookingState> entry : this.cookingStateBySlot.entrySet()) {
            CompoundTag stateTag = new CompoundTag();
            stateTag.putInt("Progress", entry.getValue().getProgress());
            stateTag.putInt("TotalTime", entry.getValue().getTotalTime());
            cookingStateTag.put(entry.getKey().toString(), (Tag)stateTag);
        }
        tag.put("CookingStateBySlot", (Tag)cookingStateTag);
        CompoundTag compoundTag = new CompoundTag();
        for (Map.Entry<Integer, Object2IntOpenHashMap<ResourceLocation>> entry : this.recipesUsedPerSlot.entrySet()) {
            CompoundTag slotRecipesTag = new CompoundTag();
            Object2IntOpenHashMap<ResourceLocation> recipes = entry.getValue();
            recipes.forEach((key, count) -> slotRecipesTag.putInt(key.toString(), count.intValue()));
            compoundTag.put(entry.getKey().toString(), (Tag)slotRecipesTag);
        }
        tag.put("RecipesUsedPerSlot", (Tag)compoundTag);
        this.saveSide(tag);
    }

    protected void checkExport(AbstractCompressedEntityBlock blockEntity, Level level) {
        int[] outputSlots;
        for (int outputSlot : outputSlots = blockEntity.SLOTS_FOR_OUTPUT) {
            ItemStack outputStack = (ItemStack)blockEntity.items.get(outputSlot);
            if (outputStack.isEmpty() || !blockEntity.isExportEnabled() || level.isClientSide) continue;
            for (Direction direction : Direction.values()) {
                blockEntity.transferItemsOut(direction, level.getGameTime());
            }
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AbstractCompressedEntityBlock blockEntity) {
        ItemStack outputStack;
        boolean hasFuel;
        boolean wasLit = blockEntity.isLit();
        boolean hasStateChanged = false;
        blockEntity.updateAllowedItems(blockEntity.SLOTS_FOR_INPUT.length);
        if (blockEntity.isAutoSplitEnabled()) {
            blockEntity.split(true, 0, blockEntity.SLOTS_FOR_INPUT.length);
        }
        if (blockEntity.isLit()) {
            --blockEntity.litTime;
        }
        if (blockEntity.litTime <= 0) {
            blockEntity.fuelPool = 0;
        }
        boolean hasValidInput = false;
        for (int inputSlot : blockEntity.SLOTS_FOR_INPUT) {
            RecipeHolder recipeHolder;
            ItemStack inputStack = (ItemStack)blockEntity.items.get(inputSlot);
            if (inputStack.isEmpty() || (recipeHolder = (RecipeHolder)blockEntity.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(inputStack), level).orElse(null)) == null) continue;
            hasValidInput = true;
            break;
        }
        boolean bl = hasFuel = !((ItemStack)blockEntity.items.get(0)).isEmpty();
        if (!blockEntity.isLit() && hasFuel && hasValidInput && !blockEntity.allOutputsFull() && blockEntity.fuelPool <= 0) {
            ItemStack fuelStack = (ItemStack)blockEntity.items.get(0);
            blockEntity.litDuration = blockEntity.litTime = blockEntity.getBurnDuration(fuelStack);
            if (blockEntity.isLit()) {
                hasStateChanged = true;
                blockEntity.fuelPool = blockEntity.litTime;
                blockEntity.isVisualShift = false;
                if (fuelStack.hasCraftingRemainingItem()) {
                    blockEntity.items.set(0, (Object)fuelStack.getCraftingRemainingItem());
                } else {
                    fuelStack.shrink(1);
                    if (fuelStack.isEmpty()) {
                        blockEntity.items.set(0, (Object)ItemStack.EMPTY);
                    }
                }
            }
        }
        blockEntity.checkExport(blockEntity, level);
        if (blockEntity.isLit()) {
            blockEntity.allocateFuelTicks();
        }
        int[] inputSlots = blockEntity.SLOTS_FOR_INPUT;
        int[] outputSlots = blockEntity.SLOTS_FOR_OUTPUT;
        for (int i = 0; i < inputSlots.length; ++i) {
            int inputSlot = inputSlots[i];
            int outputSlot = outputSlots[i];
            ItemStack inputStack = (ItemStack)blockEntity.items.get(inputSlot);
            outputStack = (ItemStack)blockEntity.items.get(outputSlot);
            if (inputStack.isEmpty()) {
                CookingState cookingState = blockEntity.cookingStateBySlot.get(inputSlot);
                if (cookingState == null) continue;
                cookingState.resetProgress();
                continue;
            }
            RecipeHolder recipeHolder = blockEntity.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(inputStack), level).orElse(null);
            if (recipeHolder != null) {
                int fuelRemaining;
                boolean hasEnoughSpace;
                ItemStack resultStack = ((AbstractCookingRecipe)recipeHolder.value()).assemble(new SingleRecipeInput(inputStack), (HolderLookup.Provider)level.registryAccess());
                boolean isSameOutputItem = outputStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)outputStack, (ItemStack)resultStack);
                boolean bl2 = hasEnoughSpace = outputStack.isEmpty() || outputStack.isStackable() && outputStack.getCount() + resultStack.getCount() <= blockEntity.getMaxStackSize();
                if (isSameOutputItem && !hasEnoughSpace) continue;
                CookingState cookingState = blockEntity.cookingStateBySlot.get(inputSlot);
                if (!isSameOutputItem) {
                    cookingState.resetProgress();
                    continue;
                }
                if (!blockEntity.isLit() || cookingState == null || (fuelRemaining = blockEntity.fuelTicksBySlot.getOrDefault(inputSlot, 0).intValue()) <= 0) continue;
                cookingState.incrementProgress();
                blockEntity.fuelTicksBySlot.put(inputSlot, fuelRemaining - 1);
                if (!cookingState.isComplete()) continue;
                BurnUtil.burn(level.registryAccess(), recipeHolder, blockEntity.items, blockEntity.getMaxStackSize(), inputSlot, outputSlot, level, blockEntity.worldPosition, blockEntity.tierID, blockEntity.isCursher(), blockEntity.isCursher(), blockEntity.isCursher() ? null : blockEntity.extraItemManager);
                cookingState.resetProgress();
                blockEntity.setRecipeUsedForSlot(recipeHolder, outputSlot);
                hasStateChanged = true;
                continue;
            }
            CookingState cookingState = blockEntity.cookingStateBySlot.get(inputSlot);
            if (cookingState == null) continue;
            cookingState.resetProgress();
        }
        for (int outputSlot : blockEntity.SLOTS_FOR_OUTPUT) {
            outputStack = (ItemStack)blockEntity.items.get(outputSlot);
            if (outputStack.isEmpty() && !blockEntity.isHasUnclaimedXP()) {
                Object2IntOpenHashMap<ResourceLocation> recipesForSlot = blockEntity.recipesUsedPerSlot.get(outputSlot);
                if (recipesForSlot == null || recipesForSlot.isEmpty()) continue;
                blockEntity.setHasUnclaimedXP(true);
                blockEntity.trackedSlotForXP = outputSlot;
                break;
            }
            if (outputStack.isEmpty() || !blockEntity.isHasUnclaimedXP() || blockEntity.trackedSlotForXP != outputSlot) continue;
            blockEntity.setHasUnclaimedXP(false);
            blockEntity.trackedSlotForXP = -1;
            break;
        }
        if (wasLit != blockEntity.isLit()) {
            hasStateChanged = true;
            state = (BlockState)state.setValue((Property)AbstractCompressedBlock.LIT, (Comparable)Boolean.valueOf(blockEntity.isLit()));
            level.setBlock(pos, state, 3);
        }
        if (hasStateChanged) {
            AbstractCompressedEntityBlock.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    protected boolean isExportEnabled() {
        return this.isExport;
    }

    protected void setAutoExport(boolean export) {
        this.isExport = export;
    }

    public void toggleAutoExport() {
        this.setAutoExport(!this.isExport);
    }

    private void allocateFuelTicks() {
        int maxFuelTime = 0;
        for (int inputSlot : this.SLOTS_FOR_INPUT) {
            int fuelRemaining = this.fuelTicksBySlot.getOrDefault(inputSlot, 0);
            CookingState cookingState = this.cookingStateBySlot.get(inputSlot);
            if (!((ItemStack)this.items.get(inputSlot)).isEmpty() && cookingState != null) {
                if (fuelRemaining <= 0) {
                    if (this.fuelPool > 0) {
                        int requiredFuel = cookingState.getTotalTime() - cookingState.getProgress();
                        int allocatedFuel = Math.min(requiredFuel, this.fuelPool);
                        this.fuelTicksBySlot.put(inputSlot, allocatedFuel);
                        this.fuelPool -= allocatedFuel;
                    } else {
                        ItemStack fuelStack = (ItemStack)this.items.get(0);
                        if (!fuelStack.isEmpty()) {
                            this.fuelPool += this.getBurnDuration(fuelStack);
                            this.litTime = this.fuelPool;
                            this.litDuration = this.fuelPool;
                            this.isVisualShift = false;
                            if (fuelStack.hasCraftingRemainingItem()) {
                                this.items.set(0, (Object)fuelStack.getCraftingRemainingItem());
                            } else {
                                fuelStack.shrink(1);
                                if (fuelStack.isEmpty()) {
                                    this.items.set(0, (Object)ItemStack.EMPTY);
                                }
                            }
                            int requiredFuel = cookingState.getTotalTime() - cookingState.getProgress();
                            int allocatedFuel = Math.min(requiredFuel, this.fuelPool);
                            this.fuelTicksBySlot.put(inputSlot, allocatedFuel);
                            this.fuelPool -= allocatedFuel;
                        }
                    }
                }
                maxFuelTime = Math.max(maxFuelTime, this.fuelTicksBySlot.getOrDefault(inputSlot, 0));
                continue;
            }
            this.fuelTicksBySlot.put(inputSlot, 0);
        }
        if (this.fuelPool <= 0 && !this.isVisualShift) {
            this.litTime = maxFuelTime;
            this.litDuration = maxFuelTime;
            this.isVisualShift = true;
        }
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.items.set(slot, (Object)stack);
        stack.limitSize(this.getMaxStackSize());
    }

    public Map<Integer, Integer> getSplitCounts(int[] slot, int[] input) {
        if (slot.length != input.length) {
            return null;
        }
        HashMap output = Maps.newHashMap();
        double sum = 0.0;
        for (int i = 0; i < input.length; ++i) {
            sum += (double)input[i];
        }
        double splitted = sum / (double)input.length;
        if (sum % (double)input.length != 0.0) {
            if (Math.floor(splitted) < splitted) {
                double lowest = Math.floor(sum / (double)input.length) * (double)input.length;
                int itemsLeftOver = (int)sum - (int)lowest;
                for (int i = 0; i < input.length; ++i) {
                    if (itemsLeftOver > 0) {
                        input[i] = (int)Math.ceil(splitted);
                        --itemsLeftOver;
                        continue;
                    }
                    input[i] = (int)splitted;
                }
            }
        } else {
            for (int i = 0; i < input.length; ++i) {
                input[i] = (int)splitted;
            }
        }
        for (int i = 0; i < input.length; ++i) {
            output.put(slot[i], input[i]);
        }
        return output;
    }

    public void fillEmptySlots(int start, int size) {
        int amount = 0;
        for (int i = start; i < size; ++i) {
            if (!this.getItem(this.SLOTS_FOR_INPUT[i]).isEmpty()) continue;
            ++amount;
        }
        if (amount == 0) {
            return;
        }
        ItemStack stack = ItemStack.EMPTY;
        for (int j = start; j < size; ++j) {
            if (this.getItem(this.SLOTS_FOR_INPUT[j]).isEmpty() || this.getItem(this.SLOTS_FOR_INPUT[j]).getCount() <= 1 || amount <= 0) continue;
            if (amount >= this.getItem(this.SLOTS_FOR_INPUT[j]).getCount()) {
                amount = this.getItem(this.SLOTS_FOR_INPUT[j]).getCount() - 1;
            }
            stack = this.getItem(this.SLOTS_FOR_INPUT[j]).copy();
            this.getItem(this.SLOTS_FOR_INPUT[j]).shrink(amount);
            for (int i = start; i < size; ++i) {
                if (!this.getItem(this.SLOTS_FOR_INPUT[i]).isEmpty() || amount <= 0) continue;
                this.setItem(this.SLOTS_FOR_INPUT[i], stack.copyWithCount(1));
                --amount;
                this.setChanged();
            }
            this.setChanged();
            break;
        }
    }

    private boolean isSlotAllowedForSplit(int slot, Set<Integer> sameOutputSlotsSet) {
        ItemStack mappedOutput = this.inputToAllowedItemsMap.getOrDefault(slot, ItemStack.EMPTY);
        if (mappedOutput.isEmpty()) {
            return true;
        }
        return sameOutputSlotsSet.contains(slot);
    }

    private void fillEmptySlotsRespectingMapping(int start, int size, Set<Integer> sameOutputSlotsSet) {
        int amount = 0;
        for (int i = start; i < size; ++i) {
            int slot = this.SLOTS_FOR_INPUT[i];
            if (!this.isSlotAllowedForSplit(slot, sameOutputSlotsSet) || !this.getItem(slot).isEmpty()) continue;
            ++amount;
        }
        if (amount == 0) {
            return;
        }
        ItemStack stack = ItemStack.EMPTY;
        for (int j = start; j < size; ++j) {
            int donorSlot = this.SLOTS_FOR_INPUT[j];
            if (!this.isSlotAllowedForSplit(donorSlot, sameOutputSlotsSet) || this.getItem(donorSlot).isEmpty() || this.getItem(donorSlot).getCount() <= 1 || amount <= 0) continue;
            if (amount >= this.getItem(donorSlot).getCount()) {
                amount = this.getItem(donorSlot).getCount() - 1;
            }
            stack = this.getItem(donorSlot).copy();
            this.getItem(donorSlot).shrink(amount);
            for (int i = start; i < size; ++i) {
                int targetSlot = this.SLOTS_FOR_INPUT[i];
                if (!this.isSlotAllowedForSplit(targetSlot, sameOutputSlotsSet) || !this.getItem(targetSlot).isEmpty() || amount <= 0) continue;
                this.setItem(targetSlot, stack.copyWithCount(1));
                --amount;
                this.setChanged();
            }
            this.setChanged();
            break;
        }
    }

    public void split(boolean fullCheck, int start, int size) {
        int i;
        ItemStack itemToCheck = ItemStack.EMPTY;
        int fullCheckCount = 0;
        if (!fullCheck) {
            for (i = start; i < size; ++i) {
                if (!this.getItem(this.SLOTS_FOR_INPUT[i]).isEmpty()) continue;
                ++fullCheckCount;
            }
            if (fullCheckCount == 0) {
                return;
            }
        }
        for (i = start; i < size; ++i) {
            if (this.getItem(this.SLOTS_FOR_INPUT[i]).isEmpty()) continue;
            itemToCheck = this.getItem(this.SLOTS_FOR_INPUT[i]).copy();
        }
        if (itemToCheck.isEmpty()) {
            return;
        }
        int[] sameOutputSlots = this.getSlotsWithSameRecipeOutput(itemToCheck);
        HashSet<Integer> sameOutputSlotsSet = new HashSet<Integer>();
        for (int s : sameOutputSlots) {
            sameOutputSlotsSet.add(s);
        }
        this.fillEmptySlotsRespectingMapping(start, size, sameOutputSlotsSet);
        HashMap items = Maps.newHashMap();
        Map<Object, Object> setCounts = Maps.newHashMap();
        for (int i2 = start; i2 < size; ++i2) {
            int slot = this.SLOTS_FOR_INPUT[i2];
            if (!this.isSlotAllowedForSplit(slot, sameOutputSlotsSet) || this.getItem(slot).isEmpty() || this.getItem(slot).getItem() != itemToCheck.getItem()) continue;
            items.put(slot, this.getItem(slot).getCount());
        }
        if (items.isEmpty()) {
            return;
        }
        int[] slot = new int[items.size()];
        int[] input = new int[items.size()];
        int j = 0;
        for (Map.Entry itemEntry : items.entrySet()) {
            slot[j] = (Integer)itemEntry.getKey();
            input[j] = (Integer)itemEntry.getValue();
            ++j;
        }
        setCounts = this.getSplitCounts(slot, input);
        int check = 0;
        for (Map.Entry<Object, Object> countsEntry : setCounts.entrySet()) {
            int count = this.getItem((Integer)countsEntry.getKey()).getCount();
            if (count != (Integer)countsEntry.getValue()) continue;
            ++check;
        }
        if (check == setCounts.size()) {
            return;
        }
        for (Map.Entry<Object, Object> countsEntry : setCounts.entrySet()) {
            ItemStack newStack = this.getItem((Integer)countsEntry.getKey()).copy();
            newStack.setCount(((Integer)countsEntry.getValue()).intValue());
            this.setItem((Integer)countsEntry.getKey(), newStack);
            this.setChanged();
        }
    }

    public int getMaxStackSize() {
        return 64;
    }

    protected boolean allOutputsFull() {
        for (int i = 0; i < this.SLOTS_FOR_INPUT.length; ++i) {
            int inputSlot = this.SLOTS_FOR_INPUT[i];
            int outputSlot = this.SLOTS_FOR_OUTPUT[i];
            if (((ItemStack)this.items.get(inputSlot)).isEmpty()) continue;
            RecipeHolder recipeHolder = this.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput((ItemStack)this.items.get(inputSlot)), this.level).orElse(null);
            if (!BurnUtil.canBurn(this.level.registryAccess(), recipeHolder, this.items, this.getMaxStackSize(), inputSlot, outputSlot, this.level, this.isCursher())) continue;
            return false;
        }
        return true;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    protected int getBurnDuration(ItemStack fuel) {
        int baseBurnTime = fuel.isEmpty() ? 0 : fuel.getBurnTime(this.recipeType);
        return (int)((double)baseBurnTime * this.getFuelMultiplier());
    }

    public static boolean isFuel(ItemStack stack) {
        return stack.getBurnTime(null) > 0;
    }

    public int[] getSlotsForFace(Direction side) {
        SideConfigHelper.SlotType slotType = this.sideConfigHelper.getSlotType(side);
        if (slotType == SideConfigHelper.SlotType.INPUT) {
            return this.SLOTS_FOR_INPUT;
        }
        if (slotType == SideConfigHelper.SlotType.OUTPUT) {
            return this.SLOTS_FOR_OUTPUT;
        }
        if (slotType == SideConfigHelper.SlotType.IO) {
            return IntStream.concat(Arrays.stream(this.SLOTS_FOR_INPUT), Arrays.stream(this.SLOTS_FOR_OUTPUT)).toArray();
        }
        if (slotType == SideConfigHelper.SlotType.FUEL) {
            return this.SLOTS_FOR_SIDES;
        }
        return new int[0];
    }

    protected int[] assignSlots(String tierID, boolean input) {
        return SlotManager.assignSlots(tierID, input);
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (this.isInputSlot(slot)) {
            RecipeHolder<?> recipeHolder = this.getRecipeForItem(stack);
            if (recipeHolder != null) {
                int inputIndex = this.findInputSlotIndex(slot);
                if (inputIndex >= 0) {
                    try {
                        int outputSlot = this.getOutputSlotForInputIndex(inputIndex);
                        ItemStack outputStack = (ItemStack)this.items.get(outputSlot);
                        ItemStack resultStack = ((AbstractCookingRecipe)recipeHolder.value()).assemble(new SingleRecipeInput(stack), (HolderLookup.Provider)this.level.registryAccess());
                        boolean OutValid = this.isOutputSlotValid(outputStack, resultStack);
                        return OutValid;
                    }
                    catch (IllegalArgumentException e) {
                        return false;
                    }
                }
                return false;
            }
            return false;
        }
        return slot == 0 && AbstractCompressedEntityBlock.isFuel(stack);
    }

    protected void updateAllowedItems(int size) {
        for (int i = 0; i < size; ++i) {
            int inputSlot = this.SLOTS_FOR_INPUT[i];
            ItemStack inputStack = (ItemStack)this.items.get(inputSlot);
            int outputSlot = this.getOutputSlotForInputIndex(i);
            ItemStack outputStack = (ItemStack)this.items.get(outputSlot);
            if (inputStack.isEmpty()) {
                if (!outputStack.isEmpty()) {
                    this.inputToAllowedItemsMap.put(inputSlot, outputStack);
                    continue;
                }
                this.inputToAllowedItemsMap.put(inputSlot, ItemStack.EMPTY);
                continue;
            }
            if (!outputStack.isEmpty()) {
                this.inputToAllowedItemsMap.put(inputSlot, outputStack);
                continue;
            }
            this.inputToAllowedItemsMap.put(inputSlot, ItemStack.EMPTY);
        }
    }

    public boolean canPlaceItemThroughFace(int i, ItemStack itemStack, @Nullable Direction direction) {
        SideConfigHelper.SlotType slotType = this.sideConfigHelper.getSlotType(direction);
        if (slotType == SideConfigHelper.SlotType.INPUT || slotType == SideConfigHelper.SlotType.IO) {
            return IntStream.of(this.SLOTS_FOR_INPUT).anyMatch(slot -> slot == i) && this.canPlaceItem(i, itemStack);
        }
        if (slotType == SideConfigHelper.SlotType.FUEL) {
            return this.canPlaceItem(i, itemStack) && AbstractCompressedEntityBlock.isFuel(itemStack);
        }
        return false;
    }

    public boolean canTakeItemThroughFace(int i, ItemStack itemStack, Direction direction) {
        SideConfigHelper.SlotType slotType = this.sideConfigHelper.getSlotType(direction);
        if (slotType != SideConfigHelper.SlotType.OUTPUT && slotType != SideConfigHelper.SlotType.IO) {
            return false;
        }
        if (i == 0) {
            return itemStack.is(Items.WATER_BUCKET) || itemStack.is(Items.BUCKET);
        }
        return IntStream.of(this.SLOTS_FOR_OUTPUT).anyMatch(slot -> slot == i);
    }

    protected void cycleSlotSideHelper(Direction side) {
        this.sideConfigHelper.cycleSlotType(side);
    }

    public void cycleSlotSide(Direction side) {
        this.cycleSlotSideHelper(side);
        this.setChanged();
    }

    protected void cycleReversSlotSideHelper(Direction side) {
        this.sideConfigHelper.cycleReversSlotType(side);
    }

    public void cycleReversSlotSide(Direction side) {
        this.cycleReversSlotSideHelper(side);
        this.setChanged();
    }

    protected void resetSlotSideHelper() {
        this.sideConfigHelper.resetToDefault();
        this.setAutoExport(false);
        this.setChanged();
    }

    public void resetSlotSides() {
        this.resetSlotSideHelper();
        this.setChanged();
    }

    protected void resetSlotTypeHelper(Direction side) {
        this.sideConfigHelper.setSlotType(side, SideConfigHelper.SlotType.NONE);
    }

    public void resetSlotType(Direction side) {
        this.resetSlotTypeHelper(side);
        this.setChanged();
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null) {
            ResourceLocation resourcelocation = recipe.id();
            this.recipesUsed.addTo((Object)resourcelocation, 1);
        }
    }

    public void setRecipeUsedForSlot(@Nullable RecipeHolder<?> recipe, int outputSlot) {
        if (recipe != null) {
            ResourceLocation recipeId = recipe.id();
            this.recipesUsedPerSlot.computeIfAbsent(outputSlot, k -> new Object2IntOpenHashMap());
            this.recipesUsedPerSlot.get(outputSlot).addTo((Object)recipeId, 1);
        }
    }

    public void giveXPWithButton(ServerPlayer player) {
        for (int i : this.SLOTS_FOR_OUTPUT) {
            ItemStack outputStack = (ItemStack)this.items.get(i);
            if (!outputStack.isEmpty()) continue;
            this.awardUsedRecipesAndPopExperience(player, i);
            this.setHasUnclaimedXP(false);
        }
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer player, int outputSlot) {
        Object2IntOpenHashMap<ResourceLocation> recipesForSlot = this.recipesUsedPerSlot.get(outputSlot);
        if (recipesForSlot != null && !recipesForSlot.isEmpty()) {
            ArrayList recipes = Lists.newArrayList();
            for (Object2IntMap.Entry entry : recipesForSlot.object2IntEntrySet()) {
                ResourceLocation recipeKey = (ResourceLocation)entry.getKey();
                int recipeCount = entry.getIntValue();
                this.level.getRecipeManager().byKey(recipeKey).ifPresent(recipe -> {
                    recipes.add(recipe);
                    AbstractCompressedEntityBlock.createExperience((ServerLevel)this.level, player.position(), recipeCount, ((AbstractCookingRecipe)recipe.value()).getExperience());
                });
            }
            player.awardRecipes((Collection)recipes);
            for (RecipeHolder recipeHolder : recipes) {
                if (recipeHolder == null) continue;
                player.triggerRecipeCrafted(recipeHolder, this.items);
            }
            recipesForSlot.clear();
        }
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(ServerLevel level, Vec3 popVec) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            level.getRecipeManager().byKey((ResourceLocation)entry.getKey()).ifPresent(p_300839_ -> {
                list.add(p_300839_);
                AbstractCompressedEntityBlock.createExperience(level, popVec, entry.getIntValue(), ((AbstractCookingRecipe)p_300839_.value()).getExperience());
            });
        }
        return list;
    }

    protected static void createExperience(ServerLevel level, Vec3 popVec, int recipeIndex, float experience) {
        int i = Mth.floor((float)((float)recipeIndex * experience));
        float f = Mth.frac((float)((float)recipeIndex * experience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.award((ServerLevel)level, (Vec3)popVec, (int)i);
    }

    public void fillStackedContents(StackedContents stackedContents) {
        for (ItemStack itemstack : this.items) {
            stackedContents.accountStack(itemstack);
        }
    }

    protected double getFuelMultiplier() {
        return switch (this.tierID) {
            case "compressed" -> (Double)Config.compressedFuelMultiplier.get();
            case "double_compressed" -> (Double)Config.doubleCompressedFuelMultiplier.get();
            case "triple_compressed" -> (Double)Config.tripleCompressedFuelMultiplier.get();
            default -> 1.0;
        };
    }

    protected void transferItemsOut(Direction direction, long currentTick) {
        BlockPos neighborPos;
        IItemHandler neighborInv;
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        SideConfigHelper.SlotType slotType = this.sideConfigHelper.getSlotType(direction);
        if ((slotType == SideConfigHelper.SlotType.OUTPUT || slotType == SideConfigHelper.SlotType.IO) && (neighborInv = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, neighborPos = this.worldPosition.relative(direction), (Object)direction.getOpposite())) != null) {
            this.transferToItemHandler(neighborInv, false, currentTick);
        }
    }

    protected void transferToItemHandler(IItemHandler handler, boolean powered, long currentTick) {
        if (currentTick - this.lastTransferTime < (long)this.calculateTransferDelayBasedOnTier(powered)) {
            return;
        }
        this.lastTransferTime = currentTick;
        int transferCount = this.calculateTransferCountBasedOnTier(powered);
        block0: for (int slot : this.SLOTS_FOR_OUTPUT) {
            ItemStack stack = (ItemStack)this.items.get(slot);
            if (stack.isEmpty()) continue;
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (!handler.getStackInSlot(i).isEmpty() && handler.insertItem(i, stack, true).getCount() >= stack.getCount()) continue;
                int transferable = Math.min(stack.getCount(), transferCount);
                ItemStack transferStack = stack.copy();
                transferStack.setCount(transferable);
                ItemStack remainder = handler.insertItem(i, transferStack, false);
                int itemsTransferred = transferable - (remainder.isEmpty() ? 0 : remainder.getCount());
                stack.shrink(itemsTransferred);
                this.setItem(slot, stack.isEmpty() ? ItemStack.EMPTY : stack);
                continue block0;
            }
        }
    }

    private int calculateTransferCountBasedOnTier(boolean powered) {
        return switch (this.tierID) {
            case "compressed" -> powered ? (Integer)Config.compressedItemPoweredTransferRate.get() : (Integer)Config.compressedItemTransferRate.get();
            case "double_compressed" -> powered ? (Integer)Config.doubleCompressedItemPoweredTransferRate.get() : (Integer)Config.doubleCompressedItemTransferRate.get();
            case "triple_compressed" -> powered ? (Integer)Config.tripleCompressedItemPoweredTransferRate.get() : (Integer)Config.tripleCompressedItemTransferRate.get();
            default -> 1;
        };
    }

    private int calculateTransferDelayBasedOnTier(boolean powered) {
        return switch (this.tierID) {
            case "compressed" -> powered ? (Integer)Config.compressedPoweredAutoItemDelay.get() : (Integer)Config.compressedAutoItemDelay.get();
            case "double_compressed" -> powered ? (Integer)Config.doubleCompressedPoweredAutoItemDelay.get() : (Integer)Config.doubleCompressedAutoItemDelay.get();
            case "triple_compressed" -> powered ? (Integer)Config.tripleCompressedPoweredAutoItemDelay.get() : (Integer)Config.tripleCompressedAutoItemDelay.get();
            default -> 40;
        };
    }

    private boolean isInputSlot(int slot) {
        return Arrays.stream(INPUTSLOTS).anyMatch(s -> s == slot);
    }

    @Nullable
    private RecipeHolder<?> getRecipeForItem(ItemStack stack) {
        return this.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(stack), this.level).orElse(null);
    }

    private int findInputSlotIndex(int slot) {
        return IntStream.range(0, INPUTSLOTS.length).filter(i -> INPUTSLOTS[i] == slot).findFirst().orElse(-1);
    }

    private int getOutputSlotForInputIndex(int inputIndes) {
        if (inputIndes < 0 || inputIndes >= this.SLOTS_FOR_OUTPUT.length) {
            throw new IllegalArgumentException("Invalid input index: " + inputIndes);
        }
        return this.SLOTS_FOR_OUTPUT[inputIndes];
    }

    private boolean isOutputSlotValid(ItemStack currentOutput, ItemStack resultStack) {
        return currentOutput.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)resultStack, (ItemStack)currentOutput);
    }

    public int[] getSlotsForOutput(ItemStack targetOutput) {
        Map<ItemStack, List<Integer>> groupedSlots = this.groupSlotsByOutput();
        for (Map.Entry<ItemStack, List<Integer>> group : groupedSlots.entrySet()) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)group.getKey(), (ItemStack)targetOutput)) continue;
            return group.getValue().stream().mapToInt(Integer::intValue).toArray();
        }
        return new int[0];
    }

    private Map<ItemStack, List<Integer>> groupSlotsByOutput() {
        HashMap<ItemStack, List<Integer>> groupedSlots = new HashMap<ItemStack, List<Integer>>();
        for (Map.Entry<Integer, ItemStack> entry : this.inputToAllowedItemsMap.entrySet()) {
            int inputSlot = entry.getKey();
            ItemStack outputStack = entry.getValue();
            if (outputStack.isEmpty()) continue;
            boolean found = false;
            for (Map.Entry group : groupedSlots.entrySet()) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)((ItemStack)group.getKey()), (ItemStack)outputStack)) continue;
                ((List)group.getValue()).add(inputSlot);
                found = true;
                break;
            }
            if (found) continue;
            groupedSlots.put(outputStack, new ArrayList<Integer>(List.of(Integer.valueOf(inputSlot))));
        }
        return groupedSlots;
    }

    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public int[] getSlotsWithSameRecipeOutput(ItemStack inputStack) {
        ItemStack recipeOutput = this.getRecipeOutputForInput(inputStack);
        if (recipeOutput.isEmpty()) {
            return new int[0];
        }
        return this.getSlotsForOutput(recipeOutput);
    }

    private ItemStack getRecipeOutputForInput(ItemStack inputStack) {
        if (inputStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        RecipeHolder<?> recipeHolder = this.getRecipeForItem(inputStack);
        if (recipeHolder != null) {
            try {
                return ((AbstractCookingRecipe)recipeHolder.value()).assemble(new SingleRecipeInput(inputStack), (HolderLookup.Provider)this.level.registryAccess());
            }
            catch (IllegalArgumentException e) {
                CompressedFurnace.LOGGER.warn("Failed to get recipe output for input {}: {}", (Object)inputStack, (Object)e.getMessage());
            }
        }
        return ItemStack.EMPTY;
    }
}

