/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.blocks.blast;

import com.mojang.serialization.MapCodec;
import net.biorfn.compressedfurnace.blocks.AbstractCompressedBlock;
import net.biorfn.compressedfurnace.entity.blast.CompressedBlastFurnaceEntity;
import net.biorfn.compressedfurnace.registries.MultiFurnaceTieredItems;
import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CompressedBlastFurnaceBlock
extends AbstractCompressedBlock {
    public static final MapCodec<CompressedBlastFurnaceBlock> CODEC = CompressedBlastFurnaceBlock.simpleCodec(CompressedBlastFurnaceBlock::new);
    public static final String ID = "compressed_blast_furnace";

    protected MapCodec<CompressedBlastFurnaceBlock> codec() {
        return CODEC;
    }

    public CompressedBlastFurnaceBlock(BlockBehaviour.Properties properties) {
        super(properties, "blast", false);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new CompressedBlastFurnaceEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return CompressedBlastFurnaceBlock.createTicker(level, blockEntityType, MultiFurnaceTieredItems.COMPRESSED_BLAST_FURNACE_TILE.get());
    }

    @Override
    protected void openContainer(Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CompressedBlastFurnaceEntity) {
            CompressedBlastFurnaceEntity compressedBlastFurnaceEntity = (CompressedBlastFurnaceEntity)blockEntity;
            player.openMenu((MenuProvider)compressedBlastFurnaceEntity);
            player.awardStat(Stats.INTERACT_WITH_BLAST_FURNACE);
        }
    }
}

