/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.blocks.Furnace;

import com.mojang.serialization.MapCodec;
import net.biorfn.compressedfurnace.blocks.AbstractCompressedBlock;
import net.biorfn.compressedfurnace.entity.furnace.TripleCompressedFurnaceEntity;
import net.biorfn.compressedfurnace.registries.MultiFurnaceTieredItems;
import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TripleCompressedFurnaceBlock
extends AbstractCompressedBlock {
    public static final MapCodec<TripleCompressedFurnaceBlock> CODEC = TripleCompressedFurnaceBlock.simpleCodec(TripleCompressedFurnaceBlock::new);
    public static final String ID = "triple_compressed_furnace";

    protected MapCodec<TripleCompressedFurnaceBlock> codec() {
        return CODEC;
    }

    public TripleCompressedFurnaceBlock(BlockBehaviour.Properties properties) {
        super(properties, "furnace", false);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new TripleCompressedFurnaceEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return TripleCompressedFurnaceBlock.createTicker(level, blockEntityType, MultiFurnaceTieredItems.TRIPLE_COMPRESSED_FURNACE_TILE.get());
    }

    @Override
    protected void openContainer(Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TripleCompressedFurnaceEntity) {
            TripleCompressedFurnaceEntity compressedFurnaceEntity = (TripleCompressedFurnaceEntity)blockEntity;
            player.openMenu((MenuProvider)compressedFurnaceEntity);
            player.awardStat(Stats.INTERACT_WITH_FURNACE);
        }
    }
}

