/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalautomation.util;

import com.blakebr0.cucumber.event.RecipeManagerLoadedEvent;
import com.blakebr0.cucumber.helper.RecipeHelper;
import com.blakebr0.mysticalautomation.MysticalAutomation;
import com.blakebr0.mysticalautomation.crafting.recipe.FarmerRecipe;
import com.blakebr0.mysticalautomation.init.ModRecipeTypes;
import com.blakebr0.mysticalautomation.network.payload.ReloadIngredientCachePayload;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public final class RecipeIngredientCache {
    public static final RecipeIngredientCache INSTANCE = new RecipeIngredientCache();
    private final Map<Key, Map<Item, List<Ingredient>>> caches = new HashMap<Key, Map<Item, List<Ingredient>>>();

    private RecipeIngredientCache() {
    }

    @SubscribeEvent
    public void onDatapackSyncEvent(OnDatapackSyncEvent event) {
        ReloadIngredientCachePayload payload = new ReloadIngredientCachePayload(this.caches);
        ServerPlayer player = event.getPlayer();
        if (player != null) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public void onRecipeManagerLoaded(RecipeManagerLoadedEvent event) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        RecipeManager manager = event.getRecipeManager();
        this.caches.clear();
        this.cacheFarmerRecipes(manager);
        MysticalAutomation.LOGGER.info("Recipe ingredient caching done in {} ms", (Object)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
    }

    public void setCaches(Map<Key, Map<Item, List<Ingredient>>> caches) {
        this.caches.clear();
        this.caches.putAll(caches);
    }

    public boolean isValidInput(Key key, ItemStack stack) {
        List cache = (List)this.caches.getOrDefault((Object)key, Collections.emptyMap()).get(stack.getItem());
        return cache != null && cache.stream().anyMatch(i -> i.test(stack));
    }

    private void cacheFarmerRecipes(RecipeManager manager) {
        this.caches.put(Key.FARMER_SEEDS, new HashMap());
        this.caches.put(Key.FARMER_SOIL, new HashMap());
        this.caches.put(Key.FARMER_CRUX, new HashMap());
        Collection recipes = RecipeHelper.byType((RecipeManager)manager, (RecipeType)((RecipeType)ModRecipeTypes.FARMER.get()));
        for (RecipeHolder recipe : recipes) {
            NonNullList<Ingredient> ingredients = ((FarmerRecipe)recipe.value()).getIngredients();
            for (int i = 0; i < 3; ++i) {
                Ingredient ingredient = (Ingredient)ingredients.get(i);
                HashSet<Item> items = new HashSet<Item>();
                for (ItemStack stack : ingredient.getItems()) {
                    Item item = stack.getItem();
                    if (items.contains(item)) continue;
                    Map<Item, List<Ingredient>> cache = switch (i) {
                        case 0 -> this.caches.get((Object)Key.FARMER_SEEDS);
                        case 1 -> this.caches.get((Object)Key.FARMER_SOIL);
                        case 2 -> this.caches.get((Object)Key.FARMER_CRUX);
                        default -> throw new IllegalStateException("Unexpected value: " + i);
                    };
                    items.add(item);
                    cache.computeIfAbsent(item, c -> new ArrayList()).add(ingredient);
                }
            }
        }
    }

    public static enum Key implements StringRepresentable
    {
        FARMER_SEEDS("farmer_seeds"),
        FARMER_SOIL("farmer_soil"),
        FARMER_CRUX("farmer_crux");

        public final String name;

        private Key(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

