/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalautomation.tileentity;

import com.blakebr0.cucumber.energy.DynamicEnergyStorage;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.OnContentsChangedFunction;
import com.blakebr0.cucumber.inventory.SidedInventoryWrapper;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.ContainerDataBuilder;
import com.blakebr0.mysticalagriculture.api.machine.IUpgradeableMachine;
import com.blakebr0.mysticalagriculture.api.machine.MachineUpgradeItemStackHandler;
import com.blakebr0.mysticalagriculture.api.machine.MachineUpgradeTier;
import com.blakebr0.mysticalautomation.block.InfuserBlock;
import com.blakebr0.mysticalautomation.compat.MysticalCompat;
import com.blakebr0.mysticalautomation.container.InfuserContainer;
import com.blakebr0.mysticalautomation.init.ModTileEntities;
import com.blakebr0.mysticalautomation.util.EssenceTier;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class InfuserTileEntity
extends BaseInventoryTileEntity
implements MenuProvider,
IUpgradeableMachine {
    private static final int INFUSION_CRYSTAL_SLOT = 0;
    private static final int[] INPUT_SLOTS = IntStream.rangeClosed(1, 6).toArray();
    private static final int FUEL_SLOT = 7;
    private static final int OUTPUT_SLOT = 8;
    public static final int FUEL_TICK_MULTIPLIER = 20;
    public static final int OPERATION_TIME = 100;
    public static final int FUEL_USAGE = 20;
    public static final int FUEL_CAPACITY = 80000;
    private final BaseItemStackHandler inventory = InfuserTileEntity.createInventoryHandler(slot -> this.setChanged());
    private final MachineUpgradeItemStackHandler upgradeInventory = new MachineUpgradeItemStackHandler();
    private final DynamicEnergyStorage energy = new DynamicEnergyStorage(80000, () -> ((InfuserTileEntity)this).setChangedFast());
    private final SidedInventoryWrapper[] sidedInventoryWrappers = SidedInventoryWrapper.create((BaseItemStackHandler)this.inventory, List.of(Direction.UP, Direction.DOWN, Direction.NORTH), this::canInsertStackSided, null);
    private final ContainerData dataAccess = ContainerDataBuilder.builder().sync(() -> ((DynamicEnergyStorage)this.energy).getEnergyStored(), arg_0 -> ((DynamicEnergyStorage)this.energy).setEnergyStored(arg_0)).sync(() -> ((DynamicEnergyStorage)this.energy).getMaxEnergyStored(), arg_0 -> ((DynamicEnergyStorage)this.energy).setMaxEnergyStorage(arg_0)).sync(() -> this.fuelLeft, value -> {
        this.fuelLeft = value;
    }).sync(() -> this.fuelItemValue, value -> {
        this.fuelItemValue = value;
    }).sync(() -> this.progress, value -> {
        this.progress = value;
    }).sync(this::getOperationTime, value -> {}).sync(() -> this.progressingIndex, value -> {
        this.progressingIndex = value;
    }).sync(() -> this.selectedIndex, value -> {
        this.selectedIndex = value;
    }).build();
    private MachineUpgradeTier tier;
    private int progress;
    private int progressingIndex;
    private int selectedIndex;
    private int fuelLeft;
    private int fuelItemValue;
    private boolean isRunning;

    public InfuserTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.INFUSER.get(), pos, state);
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.mysticalautomation.infuser");
    }

    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new InfuserContainer(i, inventory, this.inventory, this.upgradeInventory, this.dataAccess, this.getBlockPos());
    }

    public MachineUpgradeItemStackHandler getUpgradeInventory() {
        return this.upgradeInventory;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.loadAdditional(tag, lookup);
        this.progress = tag.getInt("Progress");
        this.progressingIndex = tag.getInt("ProgressingIndex");
        this.selectedIndex = tag.getInt("SelectedIndex");
        this.fuelLeft = tag.getInt("FuelLeft");
        this.fuelItemValue = tag.getInt("FuelItemValue");
        this.energy.deserializeNBT(lookup, tag.get("Energy"));
        this.upgradeInventory.deserializeNBT(lookup, tag.getCompound("UpgradeInventory"));
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.saveAdditional(tag, lookup);
        tag.putInt("Progress", this.progress);
        tag.putInt("ProgressingIndex", this.progressingIndex);
        tag.putInt("SelectedIndex", this.selectedIndex);
        tag.putInt("FuelLeft", this.fuelLeft);
        tag.putInt("FuelItemValue", this.fuelItemValue);
        tag.putInt("Energy", this.energy.getEnergyStored());
        tag.put("UpgradeInventory", (Tag)this.upgradeInventory.serializeNBT(lookup));
    }

    public static void tick(Level level, BlockPos pos, BlockState state, InfuserTileEntity tile) {
        MachineUpgradeTier tier;
        if (tile.energy.getEnergyStored() < tile.energy.getMaxEnergyStored()) {
            ItemStack fuel = tile.inventory.getStackInSlot(7);
            if (tile.fuelLeft <= 0 && !fuel.isEmpty()) {
                tile.fuelItemValue = fuel.getBurnTime(null);
                if (tile.fuelItemValue > 0) {
                    tile.fuelLeft = tile.fuelItemValue *= 20;
                    tile.inventory.setStackInSlot(7, StackHelper.shrink((ItemStack)fuel, (int)1, (boolean)true));
                    tile.setChangedFast();
                }
            }
            if (tile.fuelLeft > 0) {
                int fuelPerTick = Math.min(Math.min(tile.fuelLeft, tile.getFuelUsage() * 2), tile.energy.getMaxEnergyStored() - tile.energy.getEnergyStored());
                tile.fuelLeft -= tile.energy.receiveEnergy(fuelPerTick, false);
                if (tile.fuelLeft <= 0) {
                    tile.fuelItemValue = 0;
                }
                tile.setChangedFast();
            }
        }
        if ((tier = tile.getMachineTier()) != tile.tier) {
            tile.tier = tier;
            if (tier == null) {
                tile.energy.resetMaxEnergyStorage();
            } else {
                tile.energy.setMaxEnergyStorage(tier.getFuelCapacity(80000));
            }
            tile.setChangedFast();
        }
        boolean wasRunning = tile.isRunning;
        tile.isRunning = false;
        if (tile.energy.getEnergyStored() >= tile.getFuelUsage()) {
            ItemStack crystal = tile.inventory.getStackInSlot(0);
            if (!crystal.isEmpty() && tile.selectedIndex > 0) {
                tile.progressingIndex = tile.getNextProgressingIndex();
                ItemStack processingStack = tile.getProcessingItemStack();
                EssenceTier essenceTier = EssenceTier.fromIndex(tile.progressingIndex);
                if (!processingStack.isEmpty() && essenceTier != null && essenceTier.getNextTier() != null && essenceTier.getNextTier().getItem() != null) {
                    tile.isRunning = true;
                    if (tile.progress >= tile.getOperationTime()) {
                        int outputSlot;
                        ItemStack outputStack;
                        ItemStack result = new ItemStack((ItemLike)essenceTier.getNextTier().getItem());
                        if (StackHelper.canCombineStacks((ItemStack)result, (ItemStack)(outputStack = tile.inventory.getStackInSlot(outputSlot = tile.progressingIndex + 1 == tile.selectedIndex ? 8 : INPUT_SLOTS[tile.progressingIndex + 1])))) {
                            tile.inventory.setStackInSlot(outputSlot, StackHelper.combineStacks((ItemStack)result, (ItemStack)outputStack));
                            tile.inventory.setStackInSlot(INPUT_SLOTS[tile.progressingIndex], StackHelper.shrink((ItemStack)processingStack, (int)4, (boolean)false));
                            tile.inventory.setStackInSlot(0, crystal.getCraftingRemainingItem());
                            tile.progress = 0;
                            tile.setChangedFast();
                        }
                    } else {
                        ++tile.progress;
                        tile.energy.extractEnergy(tile.getFuelUsage(), false);
                        tile.setChangedFast();
                    }
                } else if (tile.progress > 0) {
                    tile.progress = 0;
                    tile.setChangedFast();
                }
            } else if (tile.progress > 0) {
                tile.progress = 0;
                tile.setChangedFast();
            }
        }
        if (wasRunning != tile.isRunning) {
            level.setBlock(pos, (BlockState)state.setValue((Property)InfuserBlock.RUNNING, (Comparable)Boolean.valueOf(tile.isRunning)), 3);
            tile.setChangedFast();
        }
    }

    public static BaseItemStackHandler createInventoryHandler() {
        return InfuserTileEntity.createInventoryHandler(null);
    }

    public static BaseItemStackHandler createInventoryHandler(@Nullable OnContentsChangedFunction onContentsChanged) {
        return BaseItemStackHandler.create((int)9, (OnContentsChangedFunction)onContentsChanged, handler -> {
            for (int slot2 : INPUT_SLOTS) {
                handler.addSlotLimit(slot2, 512);
            }
            handler.setCanInsert((slot, stack) -> switch (slot) {
                case 0 -> MysticalCompat.isInfusionCrystal(stack);
                case 1 -> stack.is(MysticalCompat.Items.INFERIUM_ESSENCE);
                case 2 -> stack.is(MysticalCompat.Items.PRUDENTIUM_ESSENCE);
                case 3 -> stack.is(MysticalCompat.Items.TERTIUM_ESSENCE);
                case 4 -> stack.is(MysticalCompat.Items.IMPERIUM_ESSENCE);
                case 5 -> stack.is(MysticalCompat.Items.SUPREMIUM_ESSENCE);
                case 6 -> {
                    if (MysticalCompat.Items.INSANIUM_ESSENCE.isBound() && stack.is(MysticalCompat.Items.INSANIUM_ESSENCE)) {
                        yield true;
                    }
                    yield false;
                }
                default -> true;
            });
            handler.setOutputSlots(new int[]{8});
            handler.setCanExtract(slot -> slot == 8 || slot == 7 && !FurnaceBlockEntity.isFuel((ItemStack)handler.getStackInSlot(slot)));
        });
    }

    public DynamicEnergyStorage getEnergy() {
        return this.energy;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public IItemHandler getSidedInventory(@Nullable Direction direction) {
        Direction direction2 = direction;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"UP", "DOWN"}, (Direction)direction2, n)) {
            case 0 -> this.sidedInventoryWrappers[0];
            case 1 -> this.sidedInventoryWrappers[1];
            default -> this.sidedInventoryWrappers[2];
        };
    }

    public void setSelectedIndex(int index) {
        if (index == this.selectedIndex) {
            return;
        }
        this.selectedIndex = Math.clamp((long)index, 0, INPUT_SLOTS.length - 1);
        if (index <= this.progressingIndex) {
            this.progress = 0;
        }
        this.setChangedFast();
    }

    private ItemStack getProcessingItemStack() {
        if (this.progressingIndex < 0) {
            return ItemStack.EMPTY;
        }
        return this.inventory.getStackInSlot(INPUT_SLOTS[this.progressingIndex]);
    }

    private int getOperationTime() {
        return this.tier == null ? 100 : this.tier.getOperationTime(100);
    }

    private int getFuelUsage() {
        return this.tier == null ? 20 : this.tier.getFuelUsage(20);
    }

    private int getNextProgressingIndex() {
        if (this.progress > 0) {
            return this.progressingIndex;
        }
        for (int i = this.selectedIndex - 1; i >= 0; --i) {
            ItemStack stack = this.inventory.getStackInSlot(INPUT_SLOTS[i]);
            if (stack.isEmpty() || stack.getCount() < 4) continue;
            return i;
        }
        return -1;
    }

    private boolean canInsertStackSided(int slot, ItemStack stack, @Nullable Direction direction) {
        if (direction == null) {
            return true;
        }
        if (slot == 0 && direction == Direction.UP) {
            return MysticalCompat.isInfusionCrystal(stack);
        }
        if (ArrayUtils.contains((int[])INPUT_SLOTS, (int)slot) && direction == Direction.UP) {
            return MysticalCompat.isEssence(stack);
        }
        if (slot == 7 && direction == Direction.NORTH) {
            return FurnaceBlockEntity.isFuel((ItemStack)stack);
        }
        return false;
    }
}

