/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalautomation.tileentity;

import com.blakebr0.cucumber.energy.DynamicEnergyStorage;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.CachedRecipe;
import com.blakebr0.cucumber.inventory.OnContentsChangedFunction;
import com.blakebr0.cucumber.inventory.SidedInventoryWrapper;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.ContainerDataBuilder;
import com.blakebr0.mysticalagriculture.api.machine.IUpgradeableMachine;
import com.blakebr0.mysticalagriculture.api.machine.MachineUpgradeItemStackHandler;
import com.blakebr0.mysticalagriculture.api.machine.MachineUpgradeTier;
import com.blakebr0.mysticalautomation.block.FarmerBlock;
import com.blakebr0.mysticalautomation.container.FarmerContainer;
import com.blakebr0.mysticalautomation.crafting.recipe.FarmerRecipe;
import com.blakebr0.mysticalautomation.init.ModRecipeTypes;
import com.blakebr0.mysticalautomation.init.ModTileEntities;
import com.blakebr0.mysticalautomation.util.RecipeIngredientCache;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class FarmerTileEntity
extends BaseInventoryTileEntity
implements MenuProvider,
IUpgradeableMachine {
    private static final int[] INPUT_SLOTS = IntStream.rangeClosed(0, 2).toArray();
    private static final int FUEL_SLOT = 3;
    private static final int[] OUTPUT_SLOTS = IntStream.rangeClosed(4, 12).toArray();
    public static final int FUEL_TICK_MULTIPLIER = 20;
    public static final int OPERATION_TIME = 800;
    public static final int FUEL_USAGE = 20;
    public static final int FUEL_CAPACITY = 80000;
    private final BaseItemStackHandler inventory = FarmerTileEntity.createInventoryHandler(slot -> this.setChanged());
    private final MachineUpgradeItemStackHandler upgradeInventory = new MachineUpgradeItemStackHandler();
    private final DynamicEnergyStorage energy = new DynamicEnergyStorage(80000, () -> ((FarmerTileEntity)this).setChangedFast());
    private final SidedInventoryWrapper[] sidedInventoryWrappers = SidedInventoryWrapper.create((BaseItemStackHandler)this.inventory, List.of(Direction.UP, Direction.DOWN, Direction.NORTH), this::canInsertStackSided, null);
    private final CachedRecipe<RecipeInput, FarmerRecipe> recipe = new CachedRecipe((RecipeType)ModRecipeTypes.FARMER.get());
    private final ContainerData dataAccess = ContainerDataBuilder.builder().sync(() -> ((DynamicEnergyStorage)this.energy).getEnergyStored(), arg_0 -> ((DynamicEnergyStorage)this.energy).setEnergyStored(arg_0)).sync(() -> ((DynamicEnergyStorage)this.energy).getMaxEnergyStored(), arg_0 -> ((DynamicEnergyStorage)this.energy).setMaxEnergyStorage(arg_0)).sync(() -> this.fuelLeft, value -> {
        this.fuelLeft = value;
    }).sync(() -> this.fuelItemValue, value -> {
        this.fuelItemValue = value;
    }).sync(() -> this.progress, value -> {
        this.progress = value;
    }).sync(this::getOperationTime, value -> {}).sync(() -> this.stages, value -> {
        this.stages = value;
    }).sync(() -> this.stageProgress, value -> {
        this.stageProgress = value;
    }).sync(this::getStageOperationTime, value -> {}).build();
    private MachineUpgradeTier tier;
    private int progress;
    private int stages;
    private int stageProgress;
    private int fuelLeft;
    private int fuelItemValue;
    private boolean isRunning;

    public FarmerTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.FARMER.get(), pos, state);
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.mysticalautomation.farmer");
    }

    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new FarmerContainer(i, inventory, this.inventory, this.upgradeInventory, this.dataAccess, this.getBlockPos());
    }

    public MachineUpgradeItemStackHandler getUpgradeInventory() {
        return this.upgradeInventory;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.loadAdditional(tag, lookup);
        this.progress = tag.getInt("Progress");
        this.stages = tag.getInt("Stages");
        this.stageProgress = tag.getInt("StageProgress");
        this.fuelLeft = tag.getInt("FuelLeft");
        this.fuelItemValue = tag.getInt("FuelItemValue");
        this.energy.deserializeNBT(lookup, tag.get("Energy"));
        this.upgradeInventory.deserializeNBT(lookup, tag.getCompound("UpgradeInventory"));
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.saveAdditional(tag, lookup);
        tag.putInt("Progress", this.progress);
        tag.putInt("Stages", this.stages);
        tag.putInt("StageProgress", this.stageProgress);
        tag.putInt("FuelLeft", this.fuelLeft);
        tag.putInt("FuelItemValue", this.fuelItemValue);
        tag.putInt("Energy", this.energy.getEnergyStored());
        tag.put("UpgradeInventory", (Tag)this.upgradeInventory.serializeNBT(lookup));
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FarmerTileEntity tile) {
        MachineUpgradeTier tier;
        if (tile.energy.getEnergyStored() < tile.energy.getMaxEnergyStored()) {
            ItemStack fuel = tile.inventory.getStackInSlot(3);
            if (tile.fuelLeft <= 0 && !fuel.isEmpty()) {
                tile.fuelItemValue = fuel.getBurnTime(null);
                if (tile.fuelItemValue > 0) {
                    tile.fuelLeft = tile.fuelItemValue *= 20;
                    tile.inventory.setStackInSlot(3, StackHelper.shrink((ItemStack)fuel, (int)1, (boolean)true));
                    tile.setChangedFast();
                }
            }
            if (tile.fuelLeft > 0) {
                int fuelPerTick = Math.min(Math.min(tile.fuelLeft, tile.getFuelUsage() * 2), tile.energy.getMaxEnergyStored() - tile.energy.getEnergyStored());
                tile.fuelLeft -= tile.energy.receiveEnergy(fuelPerTick, false);
                if (tile.fuelLeft <= 0) {
                    tile.fuelItemValue = 0;
                }
                tile.setChangedFast();
            }
        }
        if ((tier = tile.getMachineTier()) != tile.tier) {
            tile.tier = tier;
            if (tier == null) {
                tile.energy.resetMaxEnergyStorage();
            } else {
                tile.energy.setMaxEnergyStorage(tier.getFuelCapacity(80000));
            }
            tile.setChangedFast();
        }
        boolean wasRunning = tile.isRunning;
        tile.isRunning = false;
        if (tile.energy.getEnergyStored() >= tile.getFuelUsage()) {
            FarmerRecipe recipe = tile.getActiveRecipe();
            if (recipe != null) {
                tile.isRunning = true;
                tile.stages = recipe.getStages();
                tile.energy.extractEnergy(tile.getFuelUsage(), false);
                if (tile.stageProgress >= tile.getStageOperationTime()) {
                    ++tile.progress;
                    if (tile.progress >= tile.getOperationTime()) {
                        List<ItemStack> results = recipe.getRolledResults();
                        for (ItemStack result : results) {
                            tile.addItemToInventory(result);
                        }
                        tile.reset();
                    }
                } else {
                    ++tile.stageProgress;
                }
                tile.setChangedFast();
            } else if (tile.progress > 0 || tile.stageProgress > 0 || tile.stages > 0) {
                tile.reset();
                tile.setChangedFast();
            }
        }
        if (wasRunning != tile.isRunning) {
            level.setBlock(pos, (BlockState)state.setValue((Property)FarmerBlock.RUNNING, (Comparable)Boolean.valueOf(tile.isRunning)), 3);
            tile.setChangedFast();
        }
    }

    public static BaseItemStackHandler createInventoryHandler() {
        return FarmerTileEntity.createInventoryHandler(null);
    }

    public static BaseItemStackHandler createInventoryHandler(@Nullable OnContentsChangedFunction onContentsChanged) {
        return BaseItemStackHandler.create((int)16, (OnContentsChangedFunction)onContentsChanged, handler -> {
            handler.setCanInsert((slot, stack) -> switch (slot) {
                case 0 -> RecipeIngredientCache.INSTANCE.isValidInput(RecipeIngredientCache.Key.FARMER_SEEDS, stack);
                case 1 -> RecipeIngredientCache.INSTANCE.isValidInput(RecipeIngredientCache.Key.FARMER_SOIL, stack);
                case 2 -> RecipeIngredientCache.INSTANCE.isValidInput(RecipeIngredientCache.Key.FARMER_CRUX, stack);
                default -> true;
            });
            for (int slot2 : INPUT_SLOTS) {
                handler.addSlotLimit(slot2, 1);
            }
            handler.setOutputSlots(OUTPUT_SLOTS);
            handler.setCanExtract(slot -> ArrayUtils.contains((int[])OUTPUT_SLOTS, (int)slot) || slot == 3 && !FurnaceBlockEntity.isFuel((ItemStack)handler.getStackInSlot(slot)));
        });
    }

    public DynamicEnergyStorage getEnergy() {
        return this.energy;
    }

    public IItemHandler getSidedInventory(@Nullable Direction direction) {
        Direction direction2 = direction;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"UP", "DOWN"}, (Direction)direction2, n)) {
            case 0 -> this.sidedInventoryWrappers[0];
            case 1 -> this.sidedInventoryWrappers[1];
            default -> this.sidedInventoryWrappers[2];
        };
    }

    private void reset() {
        this.progress = 0;
        this.stages = 0;
        this.stageProgress = 0;
    }

    @Nullable
    private FarmerRecipe getActiveRecipe() {
        return (FarmerRecipe)this.recipe.checkAndGet((RecipeInput)this.toCraftingInput(), this.level);
    }

    private int getOperationTime() {
        return this.tier == null ? 800 : this.tier.getOperationTime(800);
    }

    private int getFuelUsage() {
        return this.tier == null ? 20 : this.tier.getFuelUsage(20);
    }

    private int getStageOperationTime() {
        return this.tier == null ? 800 * this.stages : this.tier.getOperationTime(800) * this.stages;
    }

    private CraftingInput toCraftingInput() {
        return this.inventory.toCraftingInput(1, 3, INPUT_SLOTS[0], INPUT_SLOTS[0] + INPUT_SLOTS.length);
    }

    private void addItemToInventory(ItemStack stack) {
        int remaining = stack.getCount();
        for (int slot : OUTPUT_SLOTS) {
            ItemStack stackInSlot = this.inventory.getStackInSlot(slot);
            if (stackInSlot.isEmpty()) {
                this.inventory.setStackInSlot(slot, stack.copy());
                return;
            }
            if (StackHelper.areStacksEqual((ItemStack)stackInSlot, (ItemStack)stack)) {
                int insertSize = Math.min(remaining, stackInSlot.getMaxStackSize() - stackInSlot.getCount());
                this.inventory.setStackInSlot(slot, StackHelper.grow((ItemStack)stackInSlot, (int)insertSize));
                remaining -= insertSize;
            }
            if (remaining != 0) continue;
            return;
        }
    }

    private boolean canInsertStackSided(int slot, ItemStack stack, @Nullable Direction direction) {
        if (direction == null) {
            return true;
        }
        if (ArrayUtils.contains((int[])INPUT_SLOTS, (int)slot) && direction == Direction.UP) {
            return true;
        }
        if (slot == 3 && direction == Direction.NORTH) {
            return FurnaceBlockEntity.isFuel((ItemStack)stack);
        }
        return false;
    }
}

