/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalautomation.network.payload;

import com.blakebr0.mysticalautomation.MysticalAutomation;
import com.blakebr0.mysticalautomation.util.RecipeIngredientCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ReloadIngredientCachePayload(Map<RecipeIngredientCache.Key, Map<Item, List<Ingredient>>> caches) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ReloadIngredientCachePayload> TYPE = new CustomPacketPayload.Type(MysticalAutomation.resource("reload_ingredient_cache"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ReloadIngredientCachePayload> STREAM_CODEC = StreamCodec.of(ReloadIngredientCachePayload::toNetwork, ReloadIngredientCachePayload::fromNetwork);

    private static ReloadIngredientCachePayload fromNetwork(RegistryFriendlyByteBuf buffer) {
        HashMap<RecipeIngredientCache.Key, Map<Item, List<Ingredient>>> caches = new HashMap<RecipeIngredientCache.Key, Map<Item, List<Ingredient>>>();
        int types = buffer.readVarInt();
        for (int i = 0; i < types; ++i) {
            RecipeIngredientCache.Key key = (RecipeIngredientCache.Key)buffer.readEnum(RecipeIngredientCache.Key.class);
            int items = buffer.readVarInt();
            caches.put(key, new HashMap());
            for (int j = 0; j < items; ++j) {
                Item item = (Item)BuiltInRegistries.ITEM.get(buffer.readResourceLocation());
                int ingredients = buffer.readVarInt();
                for (int k = 0; k < ingredients; ++k) {
                    List cache = caches.get((Object)key).computeIfAbsent(item, l -> new ArrayList());
                    Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
                    cache.add(ingredient);
                }
            }
        }
        return new ReloadIngredientCachePayload(caches);
    }

    private static void toNetwork(RegistryFriendlyByteBuf buffer, ReloadIngredientCachePayload payload) {
        buffer.writeVarInt(payload.caches.size());
        for (Map.Entry<RecipeIngredientCache.Key, Map<Item, List<Ingredient>>> entry : payload.caches.entrySet()) {
            RecipeIngredientCache.Key key = entry.getKey();
            Map<Item, List<Ingredient>> caches = entry.getValue();
            buffer.writeEnum((Enum)key);
            buffer.writeVarInt(caches.size());
            for (Map.Entry<Item, List<Ingredient>> cache : caches.entrySet()) {
                ResourceLocation item = BuiltInRegistries.ITEM.getKey((Object)cache.getKey());
                List<Ingredient> ingredients = cache.getValue();
                buffer.writeResourceLocation(item);
                buffer.writeVarInt(ingredients.size());
                for (Ingredient ingredient : ingredients) {
                    Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
                }
            }
        }
    }

    public CustomPacketPayload.Type<ReloadIngredientCachePayload> type() {
        return TYPE;
    }

    public static void handleClient(ReloadIngredientCachePayload payload, IPayloadContext context) {
        context.enqueueWork(() -> RecipeIngredientCache.INSTANCE.setCaches(payload.caches));
    }
}

