/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalautomation.crafting.recipe;

import com.blakebr0.mysticalautomation.api.crafting.IFarmerRecipe;
import com.blakebr0.mysticalautomation.init.ModRecipeSerializers;
import com.blakebr0.mysticalautomation.init.ModRecipeTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class FarmerRecipe
implements IFarmerRecipe {
    private final NonNullList<Ingredient> ingredients;
    private final int stages;
    private final List<IFarmerRecipe.FarmerResult> results;
    private final Ingredient seeds;
    private final Ingredient soil;
    private final Ingredient crux;
    private final int inputCount;

    public FarmerRecipe(Ingredient seeds, Ingredient soil, Ingredient crux, int stages, List<IFarmerRecipe.FarmerResult> results) {
        this.seeds = seeds;
        this.soil = soil;
        this.crux = crux;
        this.ingredients = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{seeds, soil, crux});
        this.stages = stages;
        this.results = results;
        this.inputCount = (int)this.ingredients.stream().filter(i -> !i.isEmpty()).count();
    }

    public boolean matches(RecipeInput input, Level level) {
        if (input.size() != this.inputCount) {
            return false;
        }
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack;
            Ingredient ingredient = (Ingredient)this.ingredients.get(i);
            if (ingredient.test(stack = input.getItem(i))) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(RecipeInput input, HolderLookup.Provider provider) {
        return this.results.getFirst().stack().copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width <= 3 && height == 1;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.results.getFirst().stack();
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.FARMER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.FARMER.get();
    }

    @Override
    public int getStages() {
        return this.stages;
    }

    @Override
    public List<IFarmerRecipe.FarmerResult> getResults() {
        return this.results;
    }

    @Override
    public List<ItemStack> getRolledResults() {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        for (IFarmerRecipe.FarmerResult result : this.results) {
            if (!((double)result.chance() > Math.random())) continue;
            results.add(result.stack().copy());
        }
        return results;
    }

    public static class Serializer
    implements RecipeSerializer<FarmerRecipe> {
        private static final MapCodec<FarmerRecipe> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.fieldOf("seeds").forGetter(recipe -> recipe.seeds), (App)Ingredient.CODEC.fieldOf("soil").forGetter(recipe -> recipe.soil), (App)Ingredient.CODEC.optionalFieldOf("crux", (Object)Ingredient.EMPTY).forGetter(recipe -> recipe.crux), (App)Codec.INT.fieldOf("stages").forGetter(recipe -> recipe.stages), (App)IFarmerRecipe.FarmerResult.CODEC.listOf().fieldOf("results").forGetter(recipe -> recipe.results)).apply((Applicative)builder, FarmerRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, FarmerRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<FarmerRecipe> codec() {
            return MAP_CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FarmerRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static FarmerRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            Ingredient seeds = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient soil = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient crux = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Integer stages = (Integer)ByteBufCodecs.VAR_INT.decode((Object)buffer);
            int size = buffer.readVarInt();
            ArrayList<IFarmerRecipe.FarmerResult> results = new ArrayList<IFarmerRecipe.FarmerResult>();
            for (int i = 0; i < size; ++i) {
                results.add((IFarmerRecipe.FarmerResult)IFarmerRecipe.FarmerResult.STREAM_CODEC.decode((Object)buffer));
            }
            return new FarmerRecipe(seeds, soil, crux, stages, results);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, FarmerRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.seeds);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.soil);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.crux);
            ByteBufCodecs.VAR_INT.encode((Object)buffer, (Object)recipe.stages);
            buffer.writeVarInt(recipe.results.size());
            for (IFarmerRecipe.FarmerResult result : recipe.results) {
                IFarmerRecipe.FarmerResult.STREAM_CODEC.encode((Object)buffer, (Object)result);
            }
        }
    }
}

