/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalautomation.compat.jei.category;

import com.blakebr0.cucumber.util.Formatting;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.mysticalautomation.MysticalAutomation;
import com.blakebr0.mysticalautomation.api.crafting.IFarmerRecipe;
import com.blakebr0.mysticalautomation.compat.MysticalCompat;
import com.blakebr0.mysticalautomation.crafting.recipe.FarmerRecipe;
import com.blakebr0.mysticalautomation.init.ModBlocks;
import com.blakebr0.mysticalautomation.lib.ModTooltips;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IScrollGridWidgetFactory;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class FarmerCategory
implements IRecipeCategory<FarmerRecipe> {
    private static final ResourceLocation TEXTURE = MysticalAutomation.resource("textures/jei/farmer.png");
    public static final RecipeType<FarmerRecipe> RECIPE_TYPE = RecipeType.create((String)"mysticalautomation", (String)"farmer", FarmerRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final Component title;
    private final IScrollGridWidgetFactory<?> scrollGridFactory;

    public FarmerCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 127, 62);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.FARMER.get()));
        this.title = Localizable.of((String)"jei.category.mysticalautomation.farmer").build();
        this.scrollGridFactory = helper.createScrollGridFactory(3, 3);
        this.scrollGridFactory.setPosition(56, 4);
    }

    public RecipeType<FarmerRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void getTooltip(ITooltipBuilder tooltip, FarmerRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX > 26.0 && mouseX < 48.0 && mouseY > 23.0 && mouseY < 39.0) {
            tooltip.add((FormattedText)ModTooltips.STAGES.args(new Object[]{Formatting.number((Object)recipe.getStages())}).color(ChatFormatting.WHITE).build());
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FarmerRecipe recipe, IFocusGroup focuses) {
        NonNullList<Ingredient> inputs = recipe.getIngredients();
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients((Ingredient)inputs.get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 23).addIngredients((Ingredient)inputs.get(1));
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 45).addIngredients((Ingredient)inputs.get(2));
        for (IFarmerRecipe.FarmerResult result : recipe.getResults()) {
            ((IRecipeSlotBuilder)builder.addSlotToWidget(RecipeIngredientRole.OUTPUT, this.scrollGridFactory).addItemStack(result.stack())).addRichTooltipCallback((slots, tooltip) -> {
                float chance = result.chance() * 100.0f;
                tooltip.add((FormattedText)MysticalCompat.Tooltips.CHANCE.args(new Object[]{Formatting.percent((Object)Float.valueOf(chance))}).build());
            });
        }
    }
}

