/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalautomation.compat.crafttweaker;

import com.blakebr0.mysticalautomation.api.crafting.IFarmerRecipe;
import com.blakebr0.mysticalautomation.crafting.recipe.FarmerRecipe;
import com.blakebr0.mysticalautomation.init.ModRecipeTypes;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.mysticalautomation.FarmerCrafting")
@ZenRegister
public final class FarmerCrafting
implements IRecipeManager<FarmerRecipe> {
    public RecipeType<FarmerRecipe> getRecipeType() {
        return (RecipeType)ModRecipeTypes.FARMER.get();
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IIngredient seeds, IIngredient soil, int stages, Map<IItemStack, Float> results) {
        this.addRecipe(name, seeds, soil, IIngredient.fromIngredient((Ingredient)Ingredient.EMPTY), stages, results);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IIngredient seeds, IIngredient soil, IIngredient crux, int stages, Map<IItemStack, Float> results) {
        ResourceLocation id = CraftTweakerConstants.rl((String)this.fixRecipeName(name));
        FarmerRecipe recipe = new FarmerRecipe(seeds.asVanillaIngredient(), soil.asVanillaIngredient(), crux.asVanillaIngredient(), stages, results.entrySet().stream().map(entry -> new IFarmerRecipe.FarmerResult(((IItemStack)entry.getKey()).getInternal(), ((Float)entry.getValue()).floatValue())).sorted(Comparator.comparing(IFarmerRecipe.FarmerResult::chance).reversed()).toList());
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, new RecipeHolder(id, (Recipe)recipe)));
    }

    @ZenCodeType.Method
    public void removeBySeeds(IItemStack seeds) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)this, holder -> ((Ingredient)((FarmerRecipe)holder.value()).getIngredients().getFirst()).test(seeds.getInternal())));
    }
}

