/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.twilightdelight.init.registrate;

import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.CreativeModeTabModifier;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.xkmc.l2core.init.reg.registrate.L2Registrate;
import dev.xkmc.twilightdelight.content.item.tool.FieryKnifeItem;
import dev.xkmc.twilightdelight.content.item.tool.IronwoodKnifeItem;
import dev.xkmc.twilightdelight.content.item.tool.KnightmetalKnifeItem;
import dev.xkmc.twilightdelight.content.item.tool.SteeleafKnifeItem;
import dev.xkmc.twilightdelight.content.item.tool.TeardropSwordItem;
import dev.xkmc.twilightdelight.init.TwilightDelight;
import dev.xkmc.twilightdelight.init.registrate.TDBlocks;
import dev.xkmc.twilightdelight.init.registrate.delight.EffectSupplier;
import dev.xkmc.twilightdelight.init.registrate.delight.IFoodType;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.model.generators.loaders.ItemLayerModelBuilder;
import org.apache.commons.lang3.StringUtils;
import vectorwing.farmersdelight.common.tag.CommonTags;
import vectorwing.farmersdelight.common.tag.ModTags;

public class TDItems {
    public static final ItemEntry<FieryKnifeItem> FIERY_KNIFE;
    public static final ItemEntry<IronwoodKnifeItem> IRONWOOD_KNIFE;
    public static final ItemEntry<SteeleafKnifeItem> STEELEAF_KNIFE;
    public static final ItemEntry<KnightmetalKnifeItem> KNIGHTMETAL_KNIFE;
    public static final ItemEntry<TeardropSwordItem> TEARDROP_SWORD;
    private static final Set<String> SMALL_WORDS;

    public static ItemEntry<Item> simpleFood(IFoodType r, String name, int nutrition, float saturation, EffectSupplier ... effects) {
        return TDItems.food(name.toLowerCase(Locale.ROOT), p -> r.create(p.rarity(r.getRarity())), () -> TDItems.simpleFood(r, nutrition, saturation, effects)).model(r::model).register();
    }

    public static FoodProperties simpleFood(IFoodType r, int nutrition, float saturation, EffectSupplier ... effects) {
        FoodProperties.Builder builder = new FoodProperties.Builder();
        builder = builder.nutrition(nutrition).saturationModifier(saturation);
        builder = r.process(builder);
        for (EffectSupplier eff : effects) {
            builder = builder.effect(eff::get, eff.chance());
        }
        r.container(builder);
        return builder.build();
    }

    private static <T extends Item> ItemBuilder<T, L2Registrate> food(String id, NonNullFunction<Item.Properties, T> factory, Supplier<FoodProperties> food) {
        return TwilightDelight.REGISTRATE.item(id, p -> (Item)factory.apply((Object)p.food((FoodProperties)food.get()))).lang(TDItems.toEnglishName(id));
    }

    public static String toEnglishName(String internalName) {
        return Arrays.stream(internalName.toLowerCase(Locale.ROOT).split("_")).map(e -> SMALL_WORDS.contains(e) ? e : StringUtils.capitalize((String)e)).collect(Collectors.joining(" "));
    }

    private static <T extends Item> ItemBuilder<T, L2Registrate> handheld(String id, NonNullFunction<Item.Properties, T> factory) {
        return TwilightDelight.REGISTRATE.item(id, factory).model((ctx, pvd) -> pvd.handheld((NonNullSupplier)ctx));
    }

    public static void register() {
    }

    static {
        IRONWOOD_KNIFE = TDItems.handheld("ironwood_knife", IronwoodKnifeItem::new).tab(TDBlocks.TAB.key(), (x, m) -> ((IronwoodKnifeItem)((Object)((Object)x.get()))).fillItemCategory((CreativeModeTabModifier)m)).tag(new TagKey[]{ModTags.KNIVES, CommonTags.TOOLS_KNIFE}).register();
        STEELEAF_KNIFE = TDItems.handheld("steeleaf_knife", SteeleafKnifeItem::new).tab(TDBlocks.TAB.key(), (x, m) -> ((SteeleafKnifeItem)((Object)((Object)x.get()))).fillItemCategory((CreativeModeTabModifier)m)).tag(new TagKey[]{ModTags.KNIVES, CommonTags.TOOLS_KNIFE}).register();
        KNIGHTMETAL_KNIFE = TDItems.handheld("knightmetal_knife", KnightmetalKnifeItem::new).lang("Knightly Knife").tag(new TagKey[]{ModTags.KNIVES, CommonTags.TOOLS_KNIFE}).register();
        FIERY_KNIFE = TDItems.handheld("fiery_knife", FieryKnifeItem::new).model((ctx, pvd) -> ((ItemLayerModelBuilder)pvd.handheld((NonNullSupplier)ctx).customLoader(ItemLayerModelBuilder::begin)).emissive(15, 15, new int[]{0})).tag(new TagKey[]{ModTags.KNIVES, CommonTags.TOOLS_KNIFE}).register();
        TEARDROP_SWORD = TDItems.handheld("teardrop_sword", TeardropSwordItem::new).model((ctx, pvd) -> ((ItemLayerModelBuilder)pvd.handheld((NonNullSupplier)ctx).customLoader(ItemLayerModelBuilder::begin)).emissive(15, 15, new int[]{0})).tag(new TagKey[]{ItemTags.SWORDS}).register();
        SMALL_WORDS = Set.of("of", "the", "with");
    }
}

