/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.twilightdelight.content.item.food;

import dev.xkmc.twilightdelight.init.data.LangData;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import vectorwing.farmersdelight.common.Configuration;

public class TDFoodItem
extends Item {
    private static Component getTooltip(MobEffectInstance eff) {
        MutableComponent ans = Component.translatable((String)eff.getDescriptionId());
        MobEffect mobeffect = (MobEffect)eff.getEffect().value();
        if (eff.getAmplifier() > 0) {
            ans = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{ans, Component.translatable((String)("potion.potency." + eff.getAmplifier()))});
        }
        if (eff.getDuration() > 20) {
            ans = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{ans, MobEffectUtil.formatDuration((MobEffectInstance)eff, (float)1.0f, (float)20.0f)});
        }
        return ans.withStyle(mobeffect.getCategory().getTooltipFormatting());
    }

    public static void getFoodEffects(ItemStack stack, List<Component> list) {
        FoodProperties food = stack.getFoodProperties(null);
        if (food == null) {
            return;
        }
        TDFoodItem.getFoodEffects(food, list);
    }

    public static void getFoodEffects(FoodProperties food, List<Component> list) {
        for (FoodProperties.PossibleEffect eff : food.effects()) {
            int chance = Math.round(eff.probability() * 100.0f);
            if (eff.effect() == null) continue;
            Component ans = TDFoodItem.getTooltip(eff.effect());
            if (chance == 100) {
                list.add(ans);
                continue;
            }
            list.add((Component)LangData.CHANCE_EFFECT.get(ans, chance));
        }
    }

    public TDFoodItem(Item.Properties props) {
        super(props);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> list, TooltipFlag flag) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            TDFoodItem.getFoodEffects(stack, list);
        }
    }
}

