/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.mob_container;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.util.FakePlayerManager;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BucketHelper {
    private static final BiMap<Item, EntityType<?>> BUCKET_TO_MOB_MAP = HashBiMap.create();

    @Nullable
    public static EntityType<?> getEntityTypeFromBucket(Item bucket) {
        ResourceLocation res;
        Optional opt;
        EntityType type = (EntityType)BUCKET_TO_MOB_MAP.get((Object)bucket);
        if (type != null) {
            return type;
        }
        if (bucket instanceof MobBucketItem) {
            MobBucketItem bucketItem = (MobBucketItem)bucket;
            EntityType en = bucketItem.type;
            BucketHelper.associateMobToBucketIfAbsent(en, bucket);
            return en;
        }
        String mobId = null;
        String itemName = Utils.getID((Item)bucket).toString();
        if (itemName.contains("_bucket")) {
            mobId = itemName.replace("_bucket", "");
        } else if (itemName.contains("bucket_of_")) {
            mobId = itemName.replace("_bucket", "");
        } else if (itemName.contains("bucket_")) {
            mobId = itemName.replace("bucket_", "");
        }
        if (mobId != null && (opt = BuiltInRegistries.ENTITY_TYPE.getOptional(res = ResourceLocation.parse((String)mobId))).isPresent()) {
            EntityType en = (EntityType)opt.get();
            BucketHelper.associateMobToBucketIfAbsent(en, bucket);
            return en;
        }
        return null;
    }

    @NotNull
    public static ItemStack getBucketFromEntity(Entity entity) {
        ItemStack b;
        ItemStack bucket = ItemStack.EMPTY;
        if (entity instanceof Bucketable) {
            Bucketable bucketable = (Bucketable)entity;
            bucket = (ItemStack)Preconditions.checkNotNull((Object)bucketable.getBucketItemStack(), (Object)("Bucketable modded entity " + String.valueOf(Utils.getID((EntityType)entity.getType())) + " returned a null bucket!"));
            bucketable.saveToBucketTag(bucket);
        } else if (entity instanceof WaterAnimal) {
            bucket = BucketHelper.tryGettingFishBucketHackery(entity, entity.level());
        } else if (CompatHandler.QUARK && !(b = QuarkCompat.getSlimeBucket(entity)).isEmpty()) {
            bucket = b;
        }
        if (!bucket.isEmpty()) {
            BucketHelper.associateMobToBucketIfAbsent(entity.getType(), bucket.getItem());
        }
        return bucket;
    }

    private static ItemStack tryGettingFishBucketHackery(Entity entity, Level level) {
        ItemStack bucket = ItemStack.EMPTY;
        Player player = FakePlayerManager.getDefault((Level)level);
        if (player != null) {
            ItemStack filledBucket;
            player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.WATER_BUCKET));
            InteractionResult result = entity.interact(player, InteractionHand.MAIN_HAND);
            if (!result.consumesAction()) {
                player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.BUCKET));
                result = entity.interact(player, InteractionHand.MAIN_HAND);
            }
            if (result.consumesAction() && !(filledBucket = player.getItemInHand(InteractionHand.MAIN_HAND)).isEmpty() && !entity.isAlive()) {
                bucket = filledBucket;
            }
        }
        return bucket;
    }

    public static Collection<Item> getValidBuckets() {
        return BUCKET_TO_MOB_MAP.keySet();
    }

    public static boolean isFishBucket(Item item) {
        return BucketHelper.getEntityTypeFromBucket(item) != null;
    }

    private static void associateMobToBucketIfAbsent(EntityType<?> entity, Item item) {
        if (!BUCKET_TO_MOB_MAP.inverse().containsKey(entity)) {
            BUCKET_TO_MOB_MAP.putIfAbsent((Object)item, entity);
        }
    }

    public static boolean isModdedFish(Entity entity) {
        return entity instanceof Bucketable;
    }
}

