/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class IronGateBlock
extends FenceGateBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final boolean gold;

    public IronGateBlock(BlockBehaviour.Properties properties, boolean gold) {
        super(WoodType.OAK, properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
        this.gold = gold;
    }

    public SoundType getSoundType(BlockState state) {
        return SoundType.METAL;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        boolean open;
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        if (CommonConfigs.Building.DOUBLE_IRON_GATE.get().booleanValue() && facing.getAxis().isVertical() && facingState.getBlock() instanceof IronGateBlock && !((Boolean)stateIn.getValue((Property)POWERED)).booleanValue() && (open = ((Boolean)facingState.getValue((Property)OPEN)).booleanValue()) != (Boolean)stateIn.getValue((Property)OPEN) && stateIn.getValue((Property)FACING) == facingState.getValue((Property)FACING)) {
            stateIn = (BlockState)stateIn.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open));
        }
        return stateIn;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, OPEN, POWERED, IN_WALL, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level world = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        boolean flag = world.hasNeighborSignal(blockpos);
        Direction direction = context.getHorizontalDirection();
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.is(FluidTags.WATER) && fluidstate.getAmount() == 8));
        return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)direction)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(flag))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(flag))).setValue((Property)IN_WALL, (Comparable)Boolean.valueOf(this.canConnect((LevelAccessor)world, blockpos, direction)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext collisionContext) {
        return ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.X ? X_SHAPE : Z_SHAPE;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        if (!world.isClientSide) {
            boolean flag = world.hasNeighborSignal(pos);
            if ((Boolean)state.getValue((Property)POWERED) != flag) {
                state = (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(flag));
                if (!(this.gold && CommonConfigs.Building.CONSISTENT_GATE.get().booleanValue() || (Boolean)state.getValue((Property)OPEN) == flag)) {
                    state = (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(flag));
                    IronGateBlock.soundAndEvent(state, world, pos, null);
                }
            }
            boolean connect = this.canConnect((LevelAccessor)world, pos, (Direction)state.getValue((Property)FACING));
            world.setBlock(pos, (BlockState)state.setValue((Property)IN_WALL, (Comparable)Boolean.valueOf(connect)), 2);
        }
    }

    private boolean canConnect(LevelAccessor world, BlockPos pos, Direction dir) {
        return this.canConnectUp(world.getBlockState(pos.above()), world, pos.above()) || this.canConnectSide(world.getBlockState(pos.relative(dir.getClockWise()))) || this.canConnectSide(world.getBlockState(pos.relative(dir.getCounterClockWise())));
    }

    private boolean canConnectSide(BlockState state) {
        return state.getBlock() instanceof IronBarsBlock;
    }

    private boolean canConnectUp(BlockState state, LevelAccessor world, BlockPos pos) {
        return state.isFaceSturdy((BlockGetter)world, pos, Direction.DOWN) || state.getBlock() instanceof IronGateBlock || state.getBlock() instanceof IronBarsBlock;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!((Boolean)state.getValue((Property)POWERED)).booleanValue() && this.gold || !CommonConfigs.Building.CONSISTENT_GATE.get().booleanValue()) {
            Direction dir = player.getDirection();
            float yaw = player.getYRot();
            if (CompatHandler.QUARK) {
                QuarkCompat.disableFenceGateStuff();
            }
            if (CommonConfigs.Building.DOUBLE_IRON_GATE.get().booleanValue()) {
                BlockPos down;
                BlockState stateDown;
                BlockPos up = pos.above();
                BlockState stateUp = level.getBlockState(up);
                if (stateUp.getBlock() instanceof IronGateBlock && stateUp.setValue((Property)IN_WALL, (Comparable)Boolean.valueOf(false)) == state.setValue((Property)IN_WALL, (Comparable)Boolean.valueOf(false))) {
                    this.openGate(stateUp, level, up, yaw);
                }
                if ((stateDown = level.getBlockState(down = pos.below())).getBlock() instanceof IronGateBlock && stateDown.setValue((Property)IN_WALL, (Comparable)Boolean.valueOf(false)) == state.setValue((Property)IN_WALL, (Comparable)Boolean.valueOf(false))) {
                    this.openGate(stateDown, level, down, yaw);
                }
            }
            this.openGate(state, level, pos, yaw);
            IronGateBlock.soundAndEvent(state, level, pos, player);
            if (CompatHandler.QUARK) {
                QuarkCompat.enableFenceGateStuff();
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    private static void soundAndEvent(BlockState state, Level level, BlockPos pos, @Nullable Player player) {
        boolean open = (Boolean)state.getValue((Property)OPEN);
        level.playSound(player, pos, open ? BlockSetType.IRON.trapdoorOpen() : BlockSetType.IRON.trapdoorClose(), SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
        level.gameEvent((Entity)player, (Holder)(open ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
    }

    private void openGate(BlockState state, Level world, BlockPos pos, float yaw) {
        if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
            state = (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.FALSE);
        } else {
            Direction myDir = (Direction)state.getValue((Property)FACING);
            Direction dir = this.getClosest(yaw, myDir, myDir.getOpposite());
            state = (BlockState)state.setValue((Property)FACING, (Comparable)dir);
            state = (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.TRUE);
        }
        world.setBlock(pos, state, 10);
    }

    private Direction getClosest(float yaw, Direction ... valid) {
        Direction closest = null;
        yaw = Mth.wrapDegrees((float)yaw);
        float min = 360.0f;
        for (Direction d : valid) {
            float angle = Mth.degreesDifferenceAbs((float)yaw, (float)d.toYRot());
            if (!(angle < min)) continue;
            min = angle;
            closest = d;
        }
        return closest;
    }

    public static BlockState messWithIronBarsState(LevelAccessor level, BlockPos clickedPos, BlockState original) {
        for (Direction d : Direction.Plane.HORIZONTAL) {
            BlockState blockState;
            BooleanProperty prop = (BooleanProperty)CrossCollisionBlock.PROPERTY_BY_DIRECTION.get(d);
            if (((Boolean)original.getValue((Property)prop)).booleanValue() || !((blockState = level.getBlockState(clickedPos.relative(d))).getBlock() instanceof FenceGateBlock) || ((Direction)blockState.getValue((Property)FenceGateBlock.FACING)).getAxis() == d.getAxis()) continue;
            original = (BlockState)original.setValue((Property)prop, (Comparable)Boolean.valueOf(true));
        }
        return original;
    }
}

