/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.cannon;

import com.mojang.datafixers.util.Pair;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonAccess;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonTrajectory;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonUtils;
import net.mehvahdjukaar.supplementaries.common.block.cannon.ShootingMode;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.common.entities.CannonBoatEntity;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CannonController {
    protected static CannonAccess access;
    private static CameraType lastCameraType;
    protected static HitResult hit;
    private static float yawIncrease;
    private static float pitchIncrease;
    private static boolean needsToUpdateServer;
    protected static ShootingMode shootingMode;
    @Nullable
    protected static CannonTrajectory trajectory;
    private static Vec3 lastCameraPos;
    private static float lastZoomOut;
    private static float lastCameraYaw;
    private static float lastCameraPitch;
    protected static boolean showsTrajectory;

    public static void startControlling(CannonAccess cannonAccess) {
        Minecraft mc = Minecraft.getInstance();
        if (access == null) {
            access = cannonAccess;
            shootingMode = cannonAccess.getInternalCannon().getTrajectoryData().drag() != 0.0f ? ShootingMode.DOWN : ShootingMode.STRAIGHT;
            lastCameraType = mc.options.getCameraType();
        }
        mc.options.setCameraType(CameraType.THIRD_PERSON_BACK);
        MutableComponent message = Component.translatable((String)"message.supplementaries.cannon.maneuver", (Object[])new Object[]{mc.options.keyShift.getTranslatedKeyMessage(), mc.options.keyAttack.getTranslatedKeyMessage()});
        mc.gui.setOverlayMessage((Component)message, false);
        mc.getNarrator().sayNow((Component)message);
    }

    private static void stopControllingAndSync() {
        if (access == null) {
            return;
        }
        access.syncToServer(false, true);
        CannonController.stopControlling();
    }

    public static void stopControlling() {
        if (access == null) {
            return;
        }
        access = null;
        lastCameraYaw = 0.0f;
        lastCameraPitch = 0.0f;
        lastZoomOut = 0.0f;
        lastCameraPos = null;
        if (lastCameraType != null) {
            Minecraft.getInstance().options.setCameraType(lastCameraType);
        }
    }

    public static boolean isActive() {
        return access != null;
    }

    public static boolean setupCamera(Camera camera, BlockGetter level, Entity entity, boolean detached, boolean thirdPersonReverse, float partialTick) {
        if (!CannonController.isActive()) {
            return false;
        }
        Vec3 centerCannonPos = access.getCannonGlobalPosition(partialTick);
        if (lastCameraPos == null) {
            lastCameraPos = camera.getPosition();
            lastCameraYaw = camera.getYRot();
            lastCameraPitch = camera.getXRot();
        }
        Vec3 targetCameraPos = centerCannonPos.add(0.0, 2.0, 0.0);
        float targetYRot = camera.getYRot() + yawIncrease;
        float targetXRot = Mth.clamp((float)(camera.getXRot() + pitchIncrease), (float)-90.0f, (float)90.0f);
        camera.setPosition(targetCameraPos);
        camera.setRotation(targetYRot, targetXRot);
        lastCameraPos = camera.getPosition();
        lastCameraYaw = camera.getYRot();
        lastCameraPitch = camera.getXRot();
        lastZoomOut = camera.getMaxZoom(4.0f);
        float horizontalOffset = -1.0f;
        camera.move(-lastZoomOut, 0.0f, horizontalOffset);
        yawIncrease = 0.0f;
        pitchIncrease = 0.0f;
        CannonBlockTile cannonTile = access.getInternalCannon();
        if (!cannonTile.isFiring()) {
            Vec3 lookDir2 = new Vec3(camera.getLookVector());
            float maxRange = 128.0f;
            Vec3 actualCameraPos = camera.getPosition().add(lookDir2.normalize());
            Vec3 endPos = actualCameraPos.add(lookDir2.scale((double)maxRange));
            hit = level.clip(new ClipContext(actualCameraPos, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, entity));
            Pair<CannonTrajectory, Float> comp = CannonUtils.computeTrajectory(access, hit.getLocation(), shootingMode);
            trajectory = (CannonTrajectory)comp.getFirst();
            float wantedYaw = ((Float)comp.getSecond()).floatValue();
            CannonController.updateCannonRenderAngles(partialTick, wantedYaw);
        }
        return true;
    }

    private static void updateCannonRenderAngles(float partialTick, float wantedYaw) {
        if (trajectory != null) {
            float followSpeed = 1.0f;
            CannonBlockTile cannon = access.getInternalCannon();
            cannon.setPitch(access, Mth.rotLerp((float)followSpeed, (float)cannon.getPitch(), (float)(trajectory.pitch() * 57.295776f)));
            cannon.setRenderYaw(access, wantedYaw * 57.295776f + access.getCannonGlobalYawOffset(partialTick));
        }
    }

    public static boolean onPlayerRotated(double yawAdd, double pitchAdd) {
        if (CannonController.isActive()) {
            float scale = 0.2f;
            yawIncrease += (float)(yawAdd * (double)scale);
            pitchIncrease += (float)(pitchAdd * (double)scale);
            if (yawAdd != 0.0 || pitchAdd != 0.0) {
                needsToUpdateServer = true;
            }
            if (access.shouldRotatePlayerFaceWhenManeuvering()) {
                LocalPlayer player = Minecraft.getInstance().player;
                player.turn(Mth.wrapDegrees((double)((double)lastCameraYaw + yawAdd - (double)player.yHeadRot)), Mth.wrapDegrees((double)((double)lastCameraPitch + pitchAdd - (double)player.getXRot())));
                player.yHeadRotO = player.yHeadRot;
                player.xRotO = player.getXRot();
            }
            return true;
        }
        return false;
    }

    private static void onKeyJump() {
        if (trajectory != null && trajectory.gravity() != 0.0f) {
            shootingMode = shootingMode.cycle();
            needsToUpdateServer = true;
        }
    }

    private static void onKeyInventory() {
        access.sendOpenGuiRequest();
    }

    private static void onKeyShift() {
        CannonController.stopControllingAndSync();
    }

    public static boolean onMouseScrolled(double scrollDelta) {
        if (!CannonController.isActive()) {
            return false;
        }
        if (scrollDelta != 0.0) {
            CannonBlockTile tile = access.getInternalCannon();
            byte newPower = (byte)(1 + Math.floorMod((int)((double)(tile.getPowerLevel() - 1) + scrollDelta), 4));
            tile.setPowerLevel(newPower);
            needsToUpdateServer = true;
        }
        return true;
    }

    public static boolean onPlayerAttack() {
        if (!CannonController.isActive()) {
            return false;
        }
        if (access != null && access.getInternalCannon().readyToFire()) {
            access.syncToServer(true, false);
        }
        return true;
    }

    public static boolean onPlayerUse() {
        if (!CannonController.isActive()) {
            return false;
        }
        showsTrajectory = !showsTrajectory;
        return true;
    }

    public static void onInputUpdate(Input input) {
        if (access.impedePlayerMovementWhenManeuvering()) {
            input.down = false;
            input.up = false;
            input.left = false;
            input.right = false;
            input.forwardImpulse = 0.0f;
            input.leftImpulse = 0.0f;
        }
        input.shiftKeyDown = false;
        input.jumping = false;
    }

    public static void onClientTick(Minecraft mc) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (!CannonController.isActive()) {
            return;
        }
        if (access.stillValid((Player)player)) {
            if (needsToUpdateServer) {
                needsToUpdateServer = false;
                access.syncToServer(false, false);
            }
        } else {
            CannonController.stopControllingAndSync();
        }
    }

    public static boolean onEarlyKeyPress(int key, int scanCode, int action, int modifiers) {
        if (!CannonController.isActive()) {
            return false;
        }
        if (action != 1) {
            return false;
        }
        Options options = Minecraft.getInstance().options;
        if (key == 256) {
            CannonController.stopControllingAndSync();
            return true;
        }
        if (options.keyInventory.matches(key, scanCode)) {
            CannonController.onKeyInventory();
            return true;
        }
        if (options.keyJump.matches(key, scanCode)) {
            CannonController.onKeyJump();
            return true;
        }
        if (options.keyShift.matches(key, scanCode)) {
            CannonController.onKeyShift();
            return true;
        }
        return false;
    }

    public static boolean cancelsXPBar() {
        return CannonController.isActive() || Minecraft.getInstance().player.getVehicle() instanceof CannonBoatEntity;
    }

    public static boolean cancelsHotBar() {
        return CannonController.isActive();
    }

    static {
        shootingMode = ShootingMode.DOWN;
        lastZoomOut = 0.0f;
        lastCameraYaw = 0.0f;
        lastCameraPitch = 0.0f;
        showsTrajectory = true;
    }
}

