/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.client.mentions;

import com.hypherionmc.craterlib.client.mentions.MentionCondition;
import com.hypherionmc.craterlib.nojang.resources.ResourceIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class MentionsController {
    private static final Map<ResourceIdentifier, Collection<String>> mentions = new LinkedHashMap<ResourceIdentifier, Collection<String>>();
    private static final Map<ResourceIdentifier, MentionCondition> mentionConditions = new LinkedHashMap<ResourceIdentifier, MentionCondition>();
    private static boolean lastMentionConditional = true;

    public static void registerMention(ResourceIdentifier mentionClass, Collection<String> suggestions, MentionCondition condition) {
        mentions.put(mentionClass, suggestions);
        mentionConditions.put(mentionClass, condition);
    }

    public static Collection<String> getMentions(String currentWord) {
        ArrayList<String> applicableMentions = new ArrayList<String>();
        lastMentionConditional = false;
        mentionConditions.forEach((mention, condition) -> {
            boolean shouldSuggest = condition.shouldAddMention(currentWord);
            if (!shouldSuggest) {
                return;
            }
            if (!lastMentionConditional && condition != MentionCondition.ALWAYS) {
                lastMentionConditional = true;
            }
            applicableMentions.addAll(mentions.get(mention));
        });
        return applicableMentions;
    }

    public static boolean hasMentions() {
        return !mentions.isEmpty();
    }

    public static boolean isLastMentionConditional() {
        return lastMentionConditional;
    }
}

