/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.block.feasts;

import com.soytutta.mynethersdelight.common.registry.MNDBlocks;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vectorwing.farmersdelight.common.block.FeastBlock;
import vectorwing.farmersdelight.common.tag.ModTags;

public class StriderloafBlock
extends FeastBlock {
    protected static final VoxelShape PLATE_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
    protected static final VoxelShape ROAST_SHAPE = Shapes.joinUnoptimized((VoxelShape)PLATE_SHAPE, (VoxelShape)Block.box((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), (BooleanOp)BooleanOp.OR);

    public StriderloafBlock(BlockBehaviour.Properties properties, Supplier<Item> servingItem, boolean hasLeftovers) {
        super(properties, servingItem, hasLeftovers);
    }

    private static boolean hasLava(LevelReader level, BlockPos pos) {
        for (BlockPos nearbyPos : BlockPos.betweenClosed((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, 1, 1))) {
            if (level.getBlockState(nearbyPos).getFluidState().is(FluidTags.LAVA)) {
                return true;
            }
            if (!nearbyPos.equals((Object)pos.below()) || !level.getBlockState(nearbyPos).is(ModTags.HEAT_SOURCES)) continue;
            return true;
        }
        return false;
    }

    private void updateBlockState(ServerLevel worldIn, BlockPos pos, BlockState newState, SoundEvent sound) {
        worldIn.setBlockAndUpdate(pos, newState);
        worldIn.playSound(null, pos, sound, SoundSource.BLOCKS, 0.25f, 0.25f);
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (!worldIn.isClientSide) {
            Block targetBlock;
            Block block = state.getBlock() == MNDBlocks.COLD_STRIDERLOAF_BLOCK.get() && StriderloafBlock.hasLava((LevelReader)worldIn, pos) ? MNDBlocks.STRIDERLOAF_BLOCK.get() : (targetBlock = state.getBlock() == MNDBlocks.STRIDERLOAF_BLOCK.get() && !StriderloafBlock.hasLava((LevelReader)worldIn, pos) ? MNDBlocks.COLD_STRIDERLOAF_BLOCK.get() : null);
            if (targetBlock != null) {
                BlockState newState = (BlockState)((BlockState)targetBlock.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)SERVINGS, (Comparable)((Integer)state.getValue((Property)SERVINGS)));
                SoundEvent sound = targetBlock == MNDBlocks.STRIDERLOAF_BLOCK.get() ? SoundEvents.STRIDER_HAPPY : SoundEvents.STRIDER_HURT;
                this.updateBlockState(worldIn, pos, newState, sound);
            }
        }
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.getBlockState(fromPos).getFluidState().is(FluidTags.LAVA)) {
            this.randomTick(state, (ServerLevel)worldIn, pos, null);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Integer)state.getValue((Property)SERVINGS) == 0 ? PLATE_SHAPE : ROAST_SHAPE;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        int servings = (Integer)blockState.getValue((Property)this.getServingsProperty());
        if (servings > 0) {
            return blockState.getBlock() == MNDBlocks.COLD_STRIDERLOAF_BLOCK.get() ? servings : servings + 1;
        }
        return blockState.getBlock() == MNDBlocks.STRIDERLOAF_BLOCK.get() ? 1 : 0;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }
}

