/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.block.crops;

import com.mojang.serialization.MapCodec;
import com.soytutta.mynethersdelight.common.block.crops.PowderyCaneBlock;
import com.soytutta.mynethersdelight.common.registry.MNDBlocks;
import com.soytutta.mynethersdelight.common.registry.MNDItems;
import com.soytutta.mynethersdelight.common.tag.MNDTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.Tags;
import vectorwing.farmersdelight.common.tag.CommonTags;

public class PowderyFlowerBlock
extends Block
implements BonemealableBlock {
    public static final MapCodec<PowderyFlowerBlock> CODEC = PowderyFlowerBlock.simpleCodec(PowderyFlowerBlock::new);
    protected static final VoxelShape SAPLING_SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final IntegerProperty PRESSURE = IntegerProperty.create((String)"pressure", (int)0, (int)2);
    public static final IntegerProperty AGE = BlockStateProperties.AGE_2;

    public PowderyFlowerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)PRESSURE, (Comparable)Integer.valueOf(0))).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public MapCodec<PowderyFlowerBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LIT, AGE, PRESSURE});
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockBelow = level.getBlockState(pos.below());
        return blockBelow.is(MNDTags.POWDERY_CANNON_PLANTABLE_ON) || blockBelow.is(MNDTags.POWDERY_CANE);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 vec3 = state.getOffset(level, pos);
        return SAPLING_SHAPE.move(vec3.x, vec3.y, vec3.z);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState offsetState, LevelAccessor level, BlockPos pos, BlockPos offsetPos) {
        int age = (Integer)state.getValue((Property)AGE);
        boolean isLit = (Boolean)state.getValue((Property)LIT);
        if (!state.canSurvive((LevelReader)level, pos) || (Integer)state.getValue((Property)PRESSURE) > 0) {
            level.scheduleTick(pos, (Block)this, 1);
        }
        if (direction == Direction.UP && offsetState.is(MNDBlocks.BULLET_PEPPER.get())) {
            level.setBlock(pos, MNDBlocks.POWDERY_CANE.get().defaultBlockState(), 2);
        }
        if (isLit && age < 2) {
            level.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
        } else if (isLit && direction == Direction.DOWN) {
            this.explodeAndReset((Level)level, pos, state, age);
        }
        return super.updateShape(state, direction, offsetState, level, pos, offsetPos);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.isClientSide) {
            return;
        }
        int age = (Integer)state.getValue((Property)AGE);
        int pressure = (Integer)state.getValue((Property)PRESSURE);
        boolean isLit = (Boolean)state.getValue((Property)LIT);
        if (!state.canSurvive((LevelReader)level, pos)) {
            if (isLit) {
                this.explodeAndReset((Level)level, pos, state, age);
            }
            level.destroyBlock(pos, true);
        }
        if (pressure > 0) {
            level.setBlock(pos, (BlockState)state.setValue((Property)PRESSURE, (Comparable)Integer.valueOf(pressure - 1)), 2);
        }
        if (pressure == 2 && isLit) {
            this.explodeAndReset((Level)level, pos, state, age);
        }
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int age = (Integer)state.getValue((Property)AGE);
        BlockState blockBelow = world.getBlockState(pos.below());
        boolean isBlockBelowPowderyCane = blockBelow.is(MNDTags.POWDERY_CANE);
        boolean isBlockBelowPerfectSoil = blockBelow.is(MNDBlocks.RESURGENT_SOIL.get()) || blockBelow.is(MNDBlocks.POWDERY_CANNON.get());
        boolean isBlockBelowPowderySoil = blockBelow.is(Blocks.CRIMSON_NYLIUM) || blockBelow.is(Blocks.GRAVEL);
        boolean isBlockBelowLeave = blockBelow.hasProperty((Property)PowderyCaneBlock.LEAVE) && (Boolean)blockBelow.getValue((Property)PowderyCaneBlock.LEAVE) == false;
        boolean maxHeight = true;
        for (int i = 1; i <= 4; ++i) {
            if (world.getBlockState(pos.below(i)).is(MNDBlocks.POWDERY_CANE.get())) continue;
            maxHeight = false;
            break;
        }
        if (age == 2 && random.nextInt(2) == 0) {
            world.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 2);
        } else if (age < 2 && CommonHooks.canCropGrow((Level)world, (BlockPos)pos, (BlockState)state, (random.nextInt(3) == 0 ? 1 : 0) != 0)) {
            world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            CommonHooks.fireCropGrowPost((Level)world, (BlockPos)pos, (BlockState)state);
        }
        if (!maxHeight) {
            if (age != 2 && random.nextInt(8) == 0 && world.isEmptyBlock(pos.above()) && isBlockBelowLeave) {
                this.growBullet((Level)world, pos);
            } else if (age <= 2 && (isBlockBelowPerfectSoil || isBlockBelowPowderyCane || isBlockBelowPowderySoil) && world.isEmptyBlock(pos.above())) {
                if (isBlockBelowPerfectSoil) {
                    this.growBullet((Level)world, pos);
                } else if (isBlockBelowPowderyCane && isBlockBelowLeave && random.nextInt(30) == 0) {
                    this.growBullet((Level)world, pos);
                } else if (!isBlockBelowLeave && random.nextInt(300) == 0) {
                    this.growBullet((Level)world, pos);
                } else if (!isBlockBelowPowderySoil && random.nextInt(1200) == 0) {
                    this.growBullet((Level)world, pos);
                }
            }
        }
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!(entity instanceof LivingEntity) || entity.getType() == EntityType.PANDA || entity.getType() == EntityType.BEE || entity.isCrouching()) {
            return;
        }
        if (!level.isClientSide && (Integer)state.getValue((Property)PRESSURE) < 2) {
            level.setBlock(pos, (BlockState)state.setValue((Property)PRESSURE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)PRESSURE) + 1)), 2);
        }
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            int age = state.hasProperty((Property)AGE) ? (Integer)state.getValue((Property)AGE) : 0;
            level.playSound(null, pos, SoundEvents.GRASS_BREAK, SoundSource.BLOCKS, 0.25f, 0.1f);
            this.explodeAndReset(level, pos, state, age);
            this.plantPepper(level, pos);
        }
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        ItemStack heldItem;
        if (!level.isClientSide && (Integer)state.getValue((Property)PRESSURE) < 2 && !player.isCrouching()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)PRESSURE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)PRESSURE) + 1)), 2);
        }
        if (!(!((Boolean)state.getValue((Property)LIT)).booleanValue() || (heldItem = player.getItemInHand(InteractionHand.MAIN_HAND)).is(CommonTags.TOOLS_KNIFE) && heldItem.is(Tags.Items.TOOLS_SHEAR))) {
            int age = state.hasProperty((Property)AGE) ? (Integer)state.getValue((Property)AGE) : 0;
            this.explodeAndReset(level, pos, state, age);
        }
        super.playerWillDestroy(level, pos, state, player);
        return state;
    }

    public void wasExploded(Level level, BlockPos pos, Explosion explosion) {
        BlockState state = level.getBlockState(pos);
        if (!level.isClientSide && state.hasProperty((Property)LIT) && ((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            int age = state.hasProperty((Property)AGE) ? (Integer)state.getValue((Property)AGE) : 0;
            this.explodeAndReset(level, pos, state, age);
        }
    }

    private void plantPepper(Level level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = pos.relative(direction);
            BlockState neighborState = level.getBlockState(neighborPos);
            BlockState belowNeighborState = level.getBlockState(neighborPos.below());
            if (!neighborState.isAir() || !belowNeighborState.is(MNDTags.POWDERY_CANNON_PLANTABLE_ON) || !((double)level.random.nextFloat() < 0.25)) continue;
            level.setBlock(neighborPos, MNDBlocks.BULLET_PEPPER.get().defaultBlockState(), 3);
            break;
        }
    }

    private void explodeAndReset(Level level, BlockPos pos, BlockState state, int age) {
        level.playSound(null, pos, SoundEvents.CREEPER_PRIMED, SoundSource.BLOCKS, 0.5f, 0.25f);
        level.explode(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 1.25f, false, Level.ExplosionInteraction.NONE);
        if (state.hasProperty((Property)AGE) && age > 0) {
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age - 1)), 3);
        }
        level.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
    }

    protected ItemInteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem;
        int age = (Integer)state.getValue((Property)AGE);
        if (age == 2 && ((Boolean)state.getValue((Property)LIT)).booleanValue() && ((heldItem = player.getItemInHand(hand)).is(CommonTags.TOOLS_KNIFE) || heldItem.is(Tags.Items.TOOLS_SHEAR))) {
            heldItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            level.destroyBlock(pos, true);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide && ((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            int age = state.hasProperty((Property)AGE) ? (Integer)state.getValue((Property)AGE) : 0;
            this.explodeAndReset(level, pos, state, age);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return false;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)MNDItems.BULLET_PEPPER.get());
    }

    protected void growBullet(Level level, BlockPos pos) {
        BlockState currentBlockState = level.getBlockState(pos);
        boolean isLit = (Boolean)currentBlockState.getValue((Property)LIT);
        BlockState newBlockState = this.defaultBlockState();
        if (isLit) {
            newBlockState = (BlockState)((BlockState)MNDBlocks.BULLET_PEPPER.get().defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(2))).setValue((Property)LIT, (Comparable)Boolean.valueOf(true));
        }
        level.setBlock(pos.above(), newBlockState, 3);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return level.getBlockState(pos.above()).isAir();
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.growBullet((Level)level, pos);
    }
}

