/*
 * Decompiled with CFR 0.152.
 */
package netherskeletons.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelnether_skeleton<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"netherskeletons", (String)"modelnether_skeleton"), "main");
    public final ModelPart head;
    public final ModelPart mushrooms_top;
    public final ModelPart mushrooms_back;
    public final ModelPart right_arm;
    public final ModelPart left_arm;
    public final ModelPart body;
    public final ModelPart right_leg;
    public final ModelPart left_leg;

    public Modelnether_skeleton(ModelPart root) {
        this.head = root.getChild("head");
        this.mushrooms_top = this.head.getChild("mushrooms_top");
        this.mushrooms_back = this.head.getChild("mushrooms_back");
        this.right_arm = root.getChild("right_arm");
        this.left_arm = root.getChild("left_arm");
        this.body = root.getChild("body");
        this.right_leg = root.getChild("right_leg");
        this.left_leg = root.getChild("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 32).addBox(-4.0f, -7.75f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition mushrooms_top = head.addOrReplaceChild("mushrooms_top", CubeListBuilder.create().texOffs(24, 4).addBox(2.0f, 0.0f, -4.0f, 6.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(24, -2).addBox(5.0f, 0.0f, -7.0f, 0.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(24, 0).addBox(-6.0f, 0.0f, -6.5f, 6.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(24, -6).addBox(-3.0f, 0.0f, -9.5f, 0.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-8.0f, (float)3.0f));
        PartDefinition mushrooms_back = head.addOrReplaceChild("mushrooms_back", CubeListBuilder.create().texOffs(36, 4).addBox(-3.0f, -3.0f, 0.0f, 6.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(36, -2).addBox(0.0f, -3.0f, -3.0f, 0.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)-2.0f, (float)5.0f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(32, 32).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(48, 16).mirror().addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(48, 32).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)).mirror(false), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, -6.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 48).addBox(-4.0f, -6.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, 0.0f, -1.1f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(24, 48).addBox(-1.9f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.1f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(8, 16).mirror().addBox(-1.0f, 0.0f, -1.1f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(40, 48).mirror().addBox(-2.1f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)).mirror(false), PartPose.offset((float)2.0f, (float)12.0f, (float)0.1f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.right_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.left_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.right_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.left_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.right_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.left_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.left_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.right_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

