/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.mixin.errorable;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.extend.Errorable;
import com.bawnorton.neruina.handler.MessageHandler;
import com.bawnorton.neruina.util.TickingEntry;
import com.bawnorton.neruina.version.Texter;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements Errorable {
    @Unique
    private boolean neruina$errored = false;
    @Unique
    private UUID neruina$tickingEntryId = null;

    @Shadow
    public abstract Component getName();

    @Shadow
    public abstract Level level();

    @Override
    public boolean neruina$isErrored() {
        return this.neruina$errored;
    }

    @Override
    public void neruina$setErrored() {
        this.neruina$errored = true;
    }

    @Override
    public void neruina$clearErrored() {
        this.neruina$errored = false;
    }

    @Override
    public void neruina$setTickingEntryId(UUID uuid) {
        this.neruina$tickingEntryId = uuid;
    }

    @Override
    public UUID neruina$getTickingEntryId() {
        return this.neruina$tickingEntryId;
    }

    @ModifyReturnValue(method={"saveWithoutId(Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/nbt/CompoundTag;"}, at={@At(value="RETURN")})
    private CompoundTag writeErroredToNbt(CompoundTag original) {
        if (this.neruina$errored) {
            original.putBoolean("neruina$errored", true);
        }
        if (this.neruina$tickingEntryId != null) {
            original.putUUID("neruina$tickingEntryId", this.neruina$tickingEntryId);
        }
        return original;
    }

    @Inject(method={"load(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/Entity;onGround:Z", opcode=181)})
    private void readErroredFromNbt(CompoundTag nbt, CallbackInfo ci) {
        if (nbt.contains("neruina$errored")) {
            this.neruina$errored = nbt.getBoolean("neruina$errored");
        }
        if (nbt.contains("neruina$tickingEntryId")) {
            this.neruina$tickingEntryId = nbt.getUUID("neruina$tickingEntryId");
        }
    }

    @ModifyReturnValue(method={"isInvulnerableTo(Lnet/minecraft/world/damagesource/DamageSource;)Z"}, at={@At(value="RETURN")})
    private boolean ignoreDamageWhenErrored(boolean original, DamageSource source) {
        if (original) {
            return true;
        }
        if (this.neruina$errored && this.neruina$tickingEntryId != null) {
            Entity entity = source.getEntity();
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                TickingEntry entry = Neruina.getInstance().getTickHandler().getTickingEntry(this.neruina$tickingEntryId);
                MessageHandler messageHandler = Neruina.getInstance().getMessageHandler();
                if (entry == null) {
                    messageHandler.sendToPlayer((Player)player, Texter.concatDelimited(Texter.LINE_BREAK, Texter.translatable("neruina.suspended.entity", this.getName().getString()), Texter.translatable("neruina.suspended.entity.untracked", new Object[0])), messageHandler.generateEntityActions((Entity)this), messageHandler.generateInfoAction());
                } else {
                    messageHandler.sendToPlayer((Player)player, Texter.translatable("neruina.suspended.entity", this.getName().getString()), messageHandler.generateEntityActions((Entity)this), messageHandler.generateResourceActions(entry));
                }
            }
            return source != this.level().damageSources().genericKill();
        }
        return false;
    }
}

