/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.mixin.catchers;

import com.bawnorton.neruina.Neruina;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Inventory.class})
public abstract class PlayerInventoryMixin {
    @Shadow
    @Final
    public NonNullList<ItemStack> items;

    @WrapOperation(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;inventoryTick(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/Entity;IZ)V")})
    private void catchTickingItemStack$notTheCauseOfTickLag(ItemStack instance, Level world, Entity entity, int slot, boolean selected, Operation<Void> original) {
        Neruina.getInstance().getTickHandler().safelyTickItemStack(instance, world, entity, slot, selected, original);
    }

    @Inject(method={"load(Lnet/minecraft/nbt/ListTag;)V"}, at={@At(value="TAIL")})
    private void removeErroredStatusOnInvInit(CallbackInfo ci) {
        this.items.forEach(stack -> {
            CustomData component = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
            if (component == null) {
                return;
            }
            CompoundTag nbt = component.copyTag();
            if (nbt.getBoolean("neruina$errored")) {
                Neruina.getInstance().getTickHandler().removeErrored(stack);
            }
        });
    }
}

