/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.data.loot.pack;

import edivad.extrastorage.loottable.StorageBlockLootFunction;
import edivad.extrastorage.setup.ESBlocks;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ExtraStorageBlockLoot
extends BlockLootSubProvider {
    protected ExtraStorageBlockLoot(HolderLookup.Provider registries) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    protected void generate() {
        ESBlocks.CRAFTER.values().forEach(block -> this.drop((Block)block.get()));
        ESBlocks.ITEM_STORAGE.values().forEach(block -> this.genBlockItemLootTableWithFunction((Block)block.get(), StorageBlockLootFunction::new));
        ESBlocks.FLUID_STORAGE.values().forEach(block -> this.genBlockItemLootTableWithFunction((Block)block.get(), StorageBlockLootFunction::new));
        this.drop((Block)ESBlocks.ADVANCED_EXPORTER.get());
        this.drop((Block)ESBlocks.ADVANCED_IMPORTER.get());
    }

    private void genBlockItemLootTableWithFunction(Block block, LootItemFunction.Builder builder) {
        this.add(block, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply(builder)).when(ExplosionCondition.survivesExplosion())));
    }

    private void drop(Block block) {
        this.add(block, this.createSingleItemTable((ItemLike)block).apply((LootItemFunction.Builder)ExtraStorageBlockLoot.copyName()));
    }

    private static CopyComponentsFunction.Builder copyName() {
        return CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(DataComponents.CUSTOM_NAME);
    }

    protected Iterable<Block> getKnownBlocks() {
        return ESBlocks.entries().stream().map(DeferredHolder::get).map(Block.class::cast).toList();
    }
}

