/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.item.tool;

import com.blakebr0.cucumber.lib.ModTags;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

public class BasePaxelItem
extends DiggerItem {
    public BasePaxelItem(Tier tier) {
        this(tier, p -> p);
    }

    public BasePaxelItem(Tier tier, Function<Item.Properties, Item.Properties> properties) {
        super(tier, ModTags.MINEABLE_WITH_PAXEL, properties.apply(new Item.Properties().attributes(BasePaxelItem.createAttributes((Tier)tier, (float)4.0f, (float)-3.2f)).durability((int)((double)tier.getUses() * 1.5))));
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility ability) {
        return ItemAbilities.DEFAULT_AXE_ACTIONS.contains(ability) || ItemAbilities.DEFAULT_PICKAXE_ACTIONS.contains(ability) || ItemAbilities.DEFAULT_SHOVEL_ACTIONS.contains(ability);
    }

    public InteractionResult useOn(UseOnContext context) {
        InteractionResult result = BasePaxelItem.tryAxeUseOn(context);
        if (result == InteractionResult.PASS) {
            result = BasePaxelItem.tryShovelUseOn(context);
        }
        return result;
    }

    private static InteractionResult tryAxeUseOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        BlockState state = level.getBlockState(pos);
        Optional<BlockState> axeStripped = Optional.ofNullable(state.getToolModifiedState(context, ItemAbilities.AXE_STRIP, false));
        Optional<BlockState> axeScraped = Optional.ofNullable(state.getToolModifiedState(context, ItemAbilities.AXE_SCRAPE, false));
        Optional<BlockState> axeWaxedOff = Optional.ofNullable(state.getToolModifiedState(context, ItemAbilities.AXE_WAX_OFF, false));
        Optional<Object> modifiedState = Optional.empty();
        if (axeStripped.isPresent()) {
            level.playSound(player, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            modifiedState = axeStripped;
        } else if (axeScraped.isPresent()) {
            level.playSound(player, pos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.levelEvent(player, 3005, pos, 0);
            modifiedState = axeScraped;
        } else if (axeWaxedOff.isPresent()) {
            level.playSound(player, pos, SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.levelEvent(player, 3004, pos, 0);
            modifiedState = axeWaxedOff;
        }
        if (modifiedState.isPresent()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, pos, stack);
            }
            level.setBlock(pos, (BlockState)modifiedState.get(), 11);
            if (player != null) {
                stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult tryShovelUseOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        BlockState state = level.getBlockState(pos);
        BlockState modifiedState = state.getToolModifiedState(context, ItemAbilities.SHOVEL_FLATTEN, false);
        BlockState newState = null;
        if (modifiedState != null && level.isEmptyBlock(pos.above())) {
            level.playSound(player, pos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
            newState = modifiedState;
        } else if (state.getBlock() instanceof CampfireBlock && ((Boolean)state.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
            if (!level.isClientSide()) {
                level.levelEvent(null, 1009, pos, 0);
            }
            CampfireBlock.dowse((Entity)player, (LevelAccessor)level, (BlockPos)pos, (BlockState)state);
            newState = (BlockState)state.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.FALSE);
        }
        if (newState != null) {
            if (!level.isClientSide()) {
                level.setBlock(pos, newState, 11);
                if (player != null) {
                    stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.PASS;
    }
}

