/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.crafting.recipe;

import com.blakebr0.cucumber.init.ModRecipeSerializers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;

public class ShapedNoMirrorRecipe
extends ShapedRecipe {
    private final ItemStack result;

    public ShapedNoMirrorRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result, boolean showNotification) {
        super(group, category, pattern, result, showNotification);
        this.result = result;
    }

    public boolean matches(CraftingInput inventory, Level level) {
        for (int i = 0; i <= inventory.width() - this.pattern.width(); ++i) {
            for (int j = 0; j <= inventory.height() - this.pattern.height(); ++j) {
                if (!this.checkMatch(inventory, i, j)) continue;
                return true;
            }
        }
        return false;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.CRAFTING_SHAPED_NO_MIRROR.get();
    }

    private boolean checkMatch(CraftingInput inventory, int x, int y) {
        for (int i = 0; i < inventory.width(); ++i) {
            for (int j = 0; j < inventory.height(); ++j) {
                int k = i - x;
                int l = j - y;
                Ingredient ingredient = Ingredient.EMPTY;
                if (k >= 0 && l >= 0 && k < this.pattern.width() && l < this.pattern.height()) {
                    ingredient = (Ingredient)this.getIngredients().get(k + l * this.pattern.width());
                }
                if (ingredient.test(inventory.getItem(i + j * inventory.width()))) continue;
                return false;
            }
        }
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<ShapedNoMirrorRecipe> {
        public static final MapCodec<ShapedNoMirrorRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ShapedRecipe::getGroup), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(ShapedRecipe::category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(recipe -> recipe.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)Boolean.TRUE).forGetter(ShapedRecipe::showNotification)).apply((Applicative)builder, ShapedNoMirrorRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapedNoMirrorRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ShapedNoMirrorRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ShapedNoMirrorRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static ShapedNoMirrorRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String group = buffer.readUtf();
            CraftingBookCategory category = (CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class);
            ShapedRecipePattern pattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)buffer);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            boolean showNotification = buffer.readBoolean();
            return new ShapedNoMirrorRecipe(group, category, pattern, result, showNotification);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, ShapedNoMirrorRecipe recipe) {
            buffer.writeUtf(recipe.getGroup());
            buffer.writeEnum((Enum)recipe.category());
            ShapedRecipePattern.STREAM_CODEC.encode((Object)buffer, (Object)recipe.pattern);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeBoolean(recipe.showNotification());
        }
    }
}

