/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.client.handler;

import com.blakebr0.cucumber.config.ModConfigs;
import com.blakebr0.cucumber.helper.FluidHelper;
import com.blakebr0.cucumber.lib.Tooltips;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

public final class TagTooltipHandler {
    @SubscribeEvent(priority=EventPriority.LOW)
    public void onItemTooltip(ItemTooltipEvent event) {
        if (!((Boolean)ModConfigs.ENABLE_TAG_TOOLTIPS.get()).booleanValue()) {
            return;
        }
        if (Minecraft.getInstance().options.advancedItemTooltips) {
            ItemStack stack = event.getItemStack();
            Block block = Block.byItem((Item)stack.getItem());
            List<Object> blockTags = block == Blocks.AIR ? List.of() : block.defaultBlockState().getTags().map(TagKey::location).toList();
            List<ResourceLocation> itemTags = stack.getTags().map(TagKey::location).toList();
            List<ResourceLocation> fluidTags = FluidHelper.getFluidTags(stack).values().stream().flatMap(Collection::stream).distinct().sorted(Comparator.comparing(ResourceLocation::toString)).toList();
            if (!(blockTags.isEmpty() && itemTags.isEmpty() && fluidTags.isEmpty())) {
                List tooltip = event.getToolTip();
                if (Screen.hasControlDown()) {
                    if (!blockTags.isEmpty()) {
                        tooltip.add(Tooltips.BLOCK_TAGS.build());
                        for (Object object : blockTags) {
                            tooltip.add(Component.literal((String)("  " + String.valueOf(object))).withStyle(ChatFormatting.DARK_GRAY));
                        }
                    }
                    if (!itemTags.isEmpty()) {
                        tooltip.add(Tooltips.ITEM_TAGS.build());
                        for (ResourceLocation resourceLocation : itemTags) {
                            tooltip.add(Component.literal((String)("  " + String.valueOf(resourceLocation))).withStyle(ChatFormatting.DARK_GRAY));
                        }
                    }
                    if (!fluidTags.isEmpty()) {
                        tooltip.add(Tooltips.FLUID_TAGS.build());
                        for (ResourceLocation resourceLocation : fluidTags) {
                            tooltip.add(Component.literal((String)("  " + String.valueOf(resourceLocation))).withStyle(ChatFormatting.DARK_GRAY));
                        }
                    }
                } else {
                    tooltip.add(Tooltips.HOLD_CTRL_FOR_TAGS.build());
                }
            }
        }
    }
}

