/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez;

import com.mojang.serialization.Codec;
import de.maxhenkel.pipez.DirectionalPosition;
import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.corelib.tag.SingleElementTag;
import de.maxhenkel.pipez.corelib.tag.Tag;
import de.maxhenkel.pipez.corelib.tag.TagUtils;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class FluidFilter
extends Filter<FluidFilter, Fluid> {
    private static final Filter.TagConverter<Fluid> TAG_CONVERTER = (single, location) -> {
        if (single) {
            return new SingleElementTag<Fluid>(location, (Fluid)BuiltInRegistries.FLUID.get(location));
        }
        return TagUtils.getFluidTag(location);
    };
    public static final Codec<Tag<Fluid>> TAG_CODEC = FluidFilter.tagCodec(TAG_CONVERTER);
    public static final StreamCodec<RegistryFriendlyByteBuf, Tag<Fluid>> STREAM_TAG_CODEC = FluidFilter.tagStreamCodec(TAG_CONVERTER);
    public static final Codec<FluidFilter> CODEC = FluidFilter.codec(FluidFilter.class, TAG_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidFilter> STREAM_CODEC = FluidFilter.streamCodec(FluidFilter.class, STREAM_TAG_CODEC);

    public FluidFilter(UUID id, @Nullable Tag<Fluid> tag, @Nullable CompoundTag metadata, boolean exactMetadata, @Nullable DirectionalPosition destination, boolean invert) {
        super(id, tag, metadata, exactMetadata, destination, invert);
    }

    @Override
    public Codec<FluidFilter> getCodec() {
        return CODEC;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, FluidFilter> getStreamCodec() {
        return STREAM_CODEC;
    }

    public FluidFilter() {
        this(UUID.randomUUID(), (Tag<Fluid>)null, (CompoundTag)null, false, (DirectionalPosition)null, false);
    }
}

