/*
 * Decompiled with CFR 0.152.
 */
package guideme.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import guideme.render.GuiAssets;
import guideme.render.SpriteFillDirection;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiSpriteManager;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.gui.GuiSpriteScaling;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

final class SpriteLayer {
    private final ResourceLocation atlasLocation = GuiAssets.GUI_SPRITE_ATLAS;
    private BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);

    public void drawSprite(ResourceLocation id, float x, float y, float z, int color) {
        GuiSpriteScaling scaling;
        GuiSpriteManager guiSprites = Minecraft.getInstance().getGuiSprites();
        TextureAtlasSprite sprite = guiSprites.getSprite(id);
        GuiSpriteScaling guiSpriteScaling = scaling = guiSprites.getSpriteScaling(sprite);
        Objects.requireNonNull(guiSpriteScaling);
        GuiSpriteScaling guiSpriteScaling2 = guiSpriteScaling;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GuiSpriteScaling.Tile.class, GuiSpriteScaling.Stretch.class, GuiSpriteScaling.NineSlice.class}, (Object)guiSpriteScaling2, n)) {
            case 0: {
                GuiSpriteScaling.Tile tiled = (GuiSpriteScaling.Tile)guiSpriteScaling2;
                this.fillSprite(id, x, y, z, tiled.width(), tiled.height(), color);
                break;
            }
            case 1: {
                GuiSpriteScaling.Stretch stretch = (GuiSpriteScaling.Stretch)guiSpriteScaling2;
                this.fillSprite(id, x, y, z, sprite.contents().width(), sprite.contents().height(), color);
                break;
            }
            case 2: {
                GuiSpriteScaling.NineSlice nineSlice = (GuiSpriteScaling.NineSlice)guiSpriteScaling2;
                this.fillSprite(id, x, y, z, nineSlice.width(), nineSlice.height(), color);
                break;
            }
        }
    }

    public void fillSprite(ResourceLocation id, float x, float y, float z, float width, float height, int color) {
        this.fillSprite(id, x, y, z, width, height, color, SpriteFillDirection.TOP_TO_BOTTOM);
    }

    public void fillSprite(ResourceLocation id, float x, float y, float z, float width, float height, int color, SpriteFillDirection fillDirection) {
        width = Math.min(65535.0f, width);
        height = Math.min(65535.0f, height);
        GuiSpriteManager guiSprites = Minecraft.getInstance().getGuiSprites();
        TextureAtlasSprite sprite = guiSprites.getSprite(id);
        GuiSpriteScaling scaling = guiSprites.getSpriteScaling(sprite);
        float u0 = sprite.getU0();
        float u1 = sprite.getU1();
        float v0 = sprite.getV0();
        float v1 = sprite.getV1();
        GuiSpriteScaling guiSpriteScaling = scaling;
        Objects.requireNonNull(guiSpriteScaling);
        GuiSpriteScaling guiSpriteScaling2 = guiSpriteScaling;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GuiSpriteScaling.Tile.class, GuiSpriteScaling.Stretch.class, GuiSpriteScaling.NineSlice.class}, (Object)guiSpriteScaling2, n)) {
            case 0: {
                GuiSpriteScaling.Tile tiled = (GuiSpriteScaling.Tile)guiSpriteScaling2;
                this.fillTiled(x, y, z, width, height, color, tiled.width(), tiled.height(), u0, u1, v0, v1, fillDirection);
                break;
            }
            case 1: {
                GuiSpriteScaling.Stretch stretch = (GuiSpriteScaling.Stretch)guiSpriteScaling2;
                this.addQuad(x, y, z, width, height, color, u0, u1, v0, v1);
                break;
            }
            case 2: {
                GuiSpriteScaling.NineSlice nineSlice = (GuiSpriteScaling.NineSlice)guiSpriteScaling2;
                this.addTiledNineSlice(id, x, y, z, width, height, color, nineSlice.width(), nineSlice.height(), nineSlice.border(), u0, u1, v0, v1);
                break;
            }
        }
    }

    private void addTiledNineSlice(ResourceLocation id, float x, float y, float z, float width, float height, int color, float nineSliceWidth, float nineSliceHeight, GuiSpriteScaling.NineSlice.Border border, float u0, float u1, float v0, float v1) {
        float leftWidth = Math.min((float)border.left(), width / 2.0f);
        float rightWidth = Math.min((float)border.right(), width / 2.0f);
        float topHeight = Math.min((float)border.top(), height / 2.0f);
        float bottomHeight = Math.min((float)border.bottom(), height / 2.0f);
        float innerWidth = nineSliceWidth - (float)border.left() - (float)border.right();
        float innerHeight = nineSliceHeight - (float)border.top() - (float)border.bottom();
        float leftU = u0 + leftWidth / nineSliceWidth * (u1 - u0);
        float rightU = u1 - rightWidth / nineSliceWidth * (u1 - u0);
        float topV = v0 + topHeight / nineSliceHeight * (v1 - v0);
        float bottomV = v1 - bottomHeight / nineSliceHeight * (v1 - v0);
        float dstInnerLeft = x + leftWidth;
        float dstInnerTop = y + topHeight;
        float dstInnerRight = x + width - rightWidth;
        float dstInnerBottom = y + height - bottomHeight;
        float dstInnerWidth = dstInnerRight - dstInnerLeft;
        float dstInnerHeight = dstInnerBottom - dstInnerTop;
        this.addQuad(x, y, z, leftWidth, topHeight, color, u0, leftU, v0, topV);
        this.addQuad(dstInnerRight, y, z, rightWidth, topHeight, color, rightU, u1, v0, topV);
        this.addQuad(dstInnerRight, dstInnerBottom, z, rightWidth, bottomHeight, color, rightU, u1, bottomV, v1);
        this.addQuad(x, dstInnerBottom, z, leftWidth, bottomHeight, color, u0, leftU, bottomV, v1);
        this.fillTiled(dstInnerLeft, y, z, dstInnerWidth, topHeight, color, innerWidth, border.top(), leftU, rightU, v0, topV);
        this.fillTiled(dstInnerLeft, dstInnerBottom, z, dstInnerWidth, bottomHeight, color, innerWidth, border.bottom(), leftU, rightU, bottomV, v1);
        this.fillTiled(x, dstInnerTop, z, leftWidth, dstInnerHeight, color, border.left(), innerHeight, u0, leftU, topV, bottomV);
        this.fillTiled(dstInnerRight, dstInnerTop, z, rightWidth, dstInnerHeight, color, border.right(), innerHeight, rightU, u1, topV, bottomV);
        this.fillTiled(dstInnerLeft, dstInnerTop, z, dstInnerWidth, dstInnerHeight, color, innerWidth, innerHeight, leftU, rightU, topV, bottomV);
    }

    private void fillTiled(float x, float y, float z, float width, float height, int color, float destTileWidth, float destTileHeight, float u0, float u1, float v0, float v1) {
        this.fillTiled(x, y, z, width, height, color, destTileWidth, destTileHeight, u0, u1, v0, v1, SpriteFillDirection.TOP_TO_BOTTOM);
    }

    private void fillTiled(float x, float y, float z, float width, float height, int color, float destTileWidth, float destTileHeight, float u0, float u1, float v0, float v1, SpriteFillDirection fillDirection) {
        if (destTileWidth <= 0.0f || destTileHeight <= 0.0f) {
            return;
        }
        float right = x + width;
        float bottom = y + height;
        if (fillDirection == SpriteFillDirection.BOTTOM_TO_TOP) {
            for (float cy = bottom; cy >= y; cy -= destTileHeight) {
                float tileHeight = Math.min(cy - y, destTileHeight);
                float tileV0 = v1 - (v1 - v0) * tileHeight / destTileHeight;
                for (float cx = x; cx < right; cx += destTileWidth) {
                    float tileWidth = Math.min(right - cx, destTileWidth);
                    float tileU1 = u0 + (u1 - u0) * tileWidth / destTileWidth;
                    this.addQuad(cx, cy - tileHeight, z, tileWidth, tileHeight, color, u0, tileU1, tileV0, v1);
                }
            }
        } else {
            for (float cy = y; cy < bottom; cy += destTileHeight) {
                float tileHeight = Math.min(bottom - cy, destTileHeight);
                float tileV1 = v0 + (v1 - v0) * tileHeight / destTileHeight;
                for (float cx = x; cx < right; cx += destTileWidth) {
                    float tileWidth = Math.min(right - cx, destTileWidth);
                    float tileU1 = u0 + (u1 - u0) * tileWidth / destTileWidth;
                    this.addQuad(cx, cy, z, tileWidth, tileHeight, color, u0, tileU1, v0, tileV1);
                }
            }
        }
    }

    public void addQuad(float x, float y, float z, float width, float height, int color, float minU, float maxU, float minV, float maxV) {
        if (width < 0.0f || height < 0.0f) {
            return;
        }
        this.builder.addVertex(x, y, z).setUv(minU, minV).setColor(color);
        this.builder.addVertex(x, y + height, z).setUv(minU, maxV).setColor(color);
        this.builder.addVertex(x + width, y + height, z).setUv(maxU, maxV).setColor(color);
        this.builder.addVertex(x + width, y, z).setUv(maxU, minV).setColor(color);
    }

    public void render(PoseStack poseStack, int x, int y, int z) {
        if (this.builder == null) {
            throw new IllegalStateException("Already rendered.");
        }
        try (MeshData meshData = this.builder.build();){
            this.builder = null;
            if (meshData == null) {
                return;
            }
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.atlasLocation);
            RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
            Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
            modelViewStack.pushMatrix();
            modelViewStack.mul((Matrix4fc)poseStack.last().pose());
            modelViewStack.translate((float)x, (float)y, (float)z);
            RenderSystem.applyModelViewMatrix();
            BufferUploader.drawWithShader((MeshData)meshData);
            modelViewStack.popMatrix();
            RenderSystem.applyModelViewMatrix();
        }
    }
}

