/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.facet.range;

import guideme.internal.shaded.lucene.facet.FacetCountsWithFilterQuery;
import guideme.internal.shaded.lucene.facet.FacetResult;
import guideme.internal.shaded.lucene.facet.FacetsCollector;
import guideme.internal.shaded.lucene.facet.LabelAndValue;
import guideme.internal.shaded.lucene.facet.range.LongRange;
import guideme.internal.shaded.lucene.facet.range.LongRangeCounter;
import guideme.internal.shaded.lucene.facet.range.Range;
import guideme.internal.shaded.lucene.index.DocValues;
import guideme.internal.shaded.lucene.index.NumericDocValues;
import guideme.internal.shaded.lucene.index.SortedNumericDocValues;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.util.PriorityQueue;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

abstract class RangeFacetCounts
extends FacetCountsWithFilterQuery {
    protected final Range[] ranges;
    protected int[] counts;
    protected final String field;
    protected int totCount;

    protected RangeFacetCounts(String field, Range[] ranges, Query fastMatchQuery) {
        super(fastMatchQuery);
        this.field = field;
        this.ranges = ranges;
    }

    protected abstract LongRange[] getLongRanges();

    protected long mapDocValue(long l) {
        return l;
    }

    protected LongRangeCounter setupCounter() {
        assert (this.counts == null);
        this.counts = new int[this.ranges.length];
        return LongRangeCounter.create(this.getLongRanges(), this.counts);
    }

    protected void count(String field, List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        SortedNumericDocValues[] multiValuedDocVals = null;
        NumericDocValues[] singleValuedDocVals = null;
        boolean foundMultiValued = false;
        for (int i = 0; i < matchingDocs.size(); ++i) {
            FacetsCollector.MatchingDocs hits = matchingDocs.get(i);
            if (hits.totalHits() == 0) continue;
            SortedNumericDocValues multiValues = DocValues.getSortedNumeric(hits.context().reader(), field);
            if (multiValuedDocVals == null) {
                multiValuedDocVals = new SortedNumericDocValues[matchingDocs.size()];
            }
            multiValuedDocVals[i] = multiValues;
            if (foundMultiValued) continue;
            NumericDocValues singleValues = DocValues.unwrapSingleton(multiValues);
            if (singleValues != null) {
                if (singleValuedDocVals == null) {
                    singleValuedDocVals = new NumericDocValues[matchingDocs.size()];
                }
                singleValuedDocVals[i] = singleValues;
                continue;
            }
            foundMultiValued = true;
        }
        if (multiValuedDocVals == null) {
            return;
        }
        if (foundMultiValued) {
            singleValuedDocVals = null;
        } else {
            multiValuedDocVals = null;
        }
        LongRangeCounter counter = this.setupCounter();
        int missingCount = 0;
        if (!foundMultiValued) {
            for (int i = 0; i < matchingDocs.size(); ++i) {
                FacetsCollector.MatchingDocs hits = matchingDocs.get(i);
                DocIdSetIterator it = this.createIterator(hits, new DocIdSetIterator[0]);
                if (it == null) continue;
                assert (singleValuedDocVals != null);
                NumericDocValues singleValues = singleValuedDocVals[i];
                this.totCount += hits.totalHits();
                int doc = it.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    if (singleValues.advanceExact(doc)) {
                        counter.addSingleValued(this.mapDocValue(singleValues.longValue()));
                    } else {
                        ++missingCount;
                    }
                    doc = it.nextDoc();
                }
            }
        } else {
            for (int i = 0; i < matchingDocs.size(); ++i) {
                DocIdSetIterator it = this.createIterator(matchingDocs.get(i), new DocIdSetIterator[0]);
                if (it == null) continue;
                SortedNumericDocValues multiValues = multiValuedDocVals[i];
                int doc = it.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    if (multiValues.advanceExact(doc)) {
                        int limit = multiValues.docValueCount();
                        if (limit == 1) {
                            counter.addSingleValued(this.mapDocValue(multiValues.nextValue()));
                            ++this.totCount;
                        } else {
                            counter.startMultiValuedDoc();
                            long previous = 0L;
                            for (int j = 0; j < limit; ++j) {
                                long val = this.mapDocValue(multiValues.nextValue());
                                if (j != 0 && val == previous) continue;
                                counter.addMultiValued(val);
                                previous = val;
                            }
                            if (counter.endMultiValuedDoc()) {
                                ++this.totCount;
                            }
                        }
                    }
                    doc = it.nextDoc();
                }
            }
        }
        this.totCount -= (missingCount += counter.finish());
    }

    @Override
    public FacetResult getAllChildren(String dim, String ... path) throws IOException {
        this.validateDimAndPathForGetChildren(dim, path);
        LabelAndValue[] labelValues = new LabelAndValue[this.ranges.length];
        if (this.counts == null) {
            for (int i = 0; i < this.ranges.length; ++i) {
                labelValues[i] = new LabelAndValue(this.ranges[i].label, 0);
            }
        } else {
            for (int i = 0; i < this.ranges.length; ++i) {
                labelValues[i] = new LabelAndValue(this.ranges[i].label, this.counts[i]);
            }
        }
        return new FacetResult(dim, path, this.totCount, labelValues, labelValues.length);
    }

    @Override
    public FacetResult getTopChildren(int topN, String dim, String ... path) throws IOException {
        RangeFacetCounts.validateTopN(topN);
        this.validateDimAndPathForGetChildren(dim, path);
        if (this.counts == null) {
            assert (this.totCount == 0);
            return new FacetResult(dim, path, this.totCount, new LabelAndValue[0], 0);
        }
        PriorityQueue<Entry> pq = new PriorityQueue<Entry>(this, Math.min(topN, this.counts.length)){

            @Override
            protected boolean lessThan(Entry a, Entry b) {
                int cmp = Integer.compare(a.count, b.count);
                if (cmp == 0) {
                    cmp = b.label.compareTo(a.label);
                }
                return cmp < 0;
            }
        };
        int childCount = 0;
        Entry e = null;
        for (int i = 0; i < this.counts.length; ++i) {
            if (this.counts[i] == 0) continue;
            ++childCount;
            if (e == null) {
                e = new Entry();
            }
            e.label = this.ranges[i].label;
            e.count = this.counts[i];
            e = pq.insertWithOverflow(e);
        }
        LabelAndValue[] results = new LabelAndValue[pq.size()];
        while (pq.size() != 0) {
            Entry entry = (Entry)pq.pop();
            results[pq.size()] = new LabelAndValue(entry.label, entry.count);
        }
        return new FacetResult(dim, path, this.totCount, results, childCount);
    }

    @Override
    public Number getSpecificValue(String dim, String ... path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<FacetResult> getAllDims(int topN) throws IOException {
        RangeFacetCounts.validateTopN(topN);
        return Collections.singletonList(this.getTopChildren(topN, this.field, new String[0]));
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RangeFacetCounts totCount=");
        b.append(this.totCount);
        b.append(":\n");
        for (int i = 0; i < this.ranges.length; ++i) {
            b.append("  ");
            b.append(this.ranges[i].label);
            b.append(" -> count=");
            b.append(this.counts != null ? this.counts[i] : 0);
            b.append('\n');
        }
        return b.toString();
    }

    private void validateDimAndPathForGetChildren(String dim, String ... path) {
        if (!dim.equals(this.field)) {
            throw new IllegalArgumentException("invalid dim \"" + dim + "\"; should be \"" + this.field + "\"");
        }
        if (path.length != 0) {
            throw new IllegalArgumentException("path.length should be 0");
        }
    }

    private static final class Entry {
        int count;
        String label;

        private Entry() {
        }
    }
}

