/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.document;

import guideme.internal.shaded.lucene.util.BytesRef;
import java.util.Objects;

public final class StoredValue {
    private final Type type;
    private int intValue;
    private long longValue;
    private float floatValue;
    private double doubleValue;
    private BytesRef binaryValue;
    private String stringValue;

    public StoredValue(int value) {
        this.type = Type.INTEGER;
        this.intValue = value;
    }

    public StoredValue(long value) {
        this.type = Type.LONG;
        this.longValue = value;
    }

    public StoredValue(float value) {
        this.type = Type.FLOAT;
        this.floatValue = value;
    }

    public StoredValue(double value) {
        this.type = Type.DOUBLE;
        this.doubleValue = value;
    }

    public StoredValue(BytesRef value) {
        this.type = Type.BINARY;
        this.binaryValue = Objects.requireNonNull(value);
    }

    public StoredValue(String value) {
        this.type = Type.STRING;
        this.stringValue = Objects.requireNonNull(value);
    }

    public Type getType() {
        return this.type;
    }

    public void setIntValue(int value) {
        if (this.type != Type.INTEGER) {
            throw new IllegalArgumentException("Cannot set an integer on a " + String.valueOf((Object)this.type) + " value");
        }
        this.intValue = value;
    }

    public void setLongValue(long value) {
        if (this.type != Type.LONG) {
            throw new IllegalArgumentException("Cannot set a long on a " + String.valueOf((Object)this.type) + " value");
        }
        this.longValue = value;
    }

    public void setFloatValue(float value) {
        if (this.type != Type.FLOAT) {
            throw new IllegalArgumentException("Cannot set a float on a " + String.valueOf((Object)this.type) + " value");
        }
        this.floatValue = value;
    }

    public void setDoubleValue(double value) {
        if (this.type != Type.DOUBLE) {
            throw new IllegalArgumentException("Cannot set a double on a " + String.valueOf((Object)this.type) + " value");
        }
        this.doubleValue = value;
    }

    public void setBinaryValue(BytesRef value) {
        if (this.type != Type.BINARY) {
            throw new IllegalArgumentException("Cannot set a binary value on a " + String.valueOf((Object)this.type) + " value");
        }
        this.binaryValue = Objects.requireNonNull(value);
    }

    public void setStringValue(String value) {
        if (this.type != Type.STRING) {
            throw new IllegalArgumentException("Cannot set a string value on a " + String.valueOf((Object)this.type) + " value");
        }
        this.stringValue = Objects.requireNonNull(value);
    }

    public int getIntValue() {
        if (this.type != Type.INTEGER) {
            throw new IllegalArgumentException("Cannot get an integer on a " + String.valueOf((Object)this.type) + " value");
        }
        return this.intValue;
    }

    public long getLongValue() {
        if (this.type != Type.LONG) {
            throw new IllegalArgumentException("Cannot get a long on a " + String.valueOf((Object)this.type) + " value");
        }
        return this.longValue;
    }

    public float getFloatValue() {
        if (this.type != Type.FLOAT) {
            throw new IllegalArgumentException("Cannot get a float on a " + String.valueOf((Object)this.type) + " value");
        }
        return this.floatValue;
    }

    public double getDoubleValue() {
        if (this.type != Type.DOUBLE) {
            throw new IllegalArgumentException("Cannot get a double on a " + String.valueOf((Object)this.type) + " value");
        }
        return this.doubleValue;
    }

    public BytesRef getBinaryValue() {
        if (this.type != Type.BINARY) {
            throw new IllegalArgumentException("Cannot get a binary value on a " + String.valueOf((Object)this.type) + " value");
        }
        return this.binaryValue;
    }

    public String getStringValue() {
        if (this.type != Type.STRING) {
            throw new IllegalArgumentException("Cannot get a string value on a " + String.valueOf((Object)this.type) + " value");
        }
        return this.stringValue;
    }

    public static enum Type {
        INTEGER,
        LONG,
        FLOAT,
        DOUBLE,
        BINARY,
        STRING;

    }
}

