/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.codecs.lucene90.compressing;

import guideme.internal.shaded.lucene.codecs.CodecUtil;
import guideme.internal.shaded.lucene.codecs.lucene90.compressing.FieldsIndex;
import guideme.internal.shaded.lucene.index.IndexFileNames;
import guideme.internal.shaded.lucene.store.Directory;
import guideme.internal.shaded.lucene.store.IOContext;
import guideme.internal.shaded.lucene.store.IndexInput;
import guideme.internal.shaded.lucene.store.RandomAccessInput;
import guideme.internal.shaded.lucene.store.ReadAdvice;
import guideme.internal.shaded.lucene.util.packed.DirectMonotonicReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;

final class FieldsIndexReader
extends FieldsIndex {
    private final int maxDoc;
    private final int blockShift;
    private final int numChunks;
    private final DirectMonotonicReader.Meta docsMeta;
    private final DirectMonotonicReader.Meta startPointersMeta;
    private final IndexInput indexInput;
    private final long docsStartPointer;
    private final long docsEndPointer;
    private final long startPointersStartPointer;
    private final long startPointersEndPointer;
    private final DirectMonotonicReader docs;
    private final DirectMonotonicReader startPointers;
    private final long maxPointer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FieldsIndexReader(Directory dir, String name, String suffix, String extension, String codecName, byte[] id, IndexInput metaIn, IOContext context) throws IOException {
        this.maxDoc = metaIn.readInt();
        this.blockShift = metaIn.readInt();
        this.numChunks = metaIn.readInt();
        this.docsStartPointer = metaIn.readLong();
        this.docsMeta = DirectMonotonicReader.loadMeta(metaIn, this.numChunks, this.blockShift);
        this.docsEndPointer = this.startPointersStartPointer = metaIn.readLong();
        this.startPointersMeta = DirectMonotonicReader.loadMeta(metaIn, this.numChunks, this.blockShift);
        this.startPointersEndPointer = metaIn.readLong();
        this.maxPointer = metaIn.readLong();
        this.indexInput = dir.openInput(IndexFileNames.segmentFileName(name, suffix, extension), context.withReadAdvice(ReadAdvice.RANDOM_PRELOAD));
        boolean success = false;
        try {
            CodecUtil.checkIndexHeader(this.indexInput, codecName + "Idx", 0, 0, id, suffix);
            CodecUtil.retrieveChecksum(this.indexInput);
            success = true;
        }
        finally {
            if (!success) {
                this.indexInput.close();
            }
        }
        RandomAccessInput docsSlice = this.indexInput.randomAccessSlice(this.docsStartPointer, this.docsEndPointer - this.docsStartPointer);
        RandomAccessInput startPointersSlice = this.indexInput.randomAccessSlice(this.startPointersStartPointer, this.startPointersEndPointer - this.startPointersStartPointer);
        this.docs = DirectMonotonicReader.getInstance(this.docsMeta, docsSlice);
        this.startPointers = DirectMonotonicReader.getInstance(this.startPointersMeta, startPointersSlice);
    }

    private FieldsIndexReader(FieldsIndexReader other) throws IOException {
        this.maxDoc = other.maxDoc;
        this.numChunks = other.numChunks;
        this.blockShift = other.blockShift;
        this.docsMeta = other.docsMeta;
        this.startPointersMeta = other.startPointersMeta;
        this.indexInput = other.indexInput.clone();
        this.docsStartPointer = other.docsStartPointer;
        this.docsEndPointer = other.docsEndPointer;
        this.startPointersStartPointer = other.startPointersStartPointer;
        this.startPointersEndPointer = other.startPointersEndPointer;
        this.maxPointer = other.maxPointer;
        RandomAccessInput docsSlice = this.indexInput.randomAccessSlice(this.docsStartPointer, this.docsEndPointer - this.docsStartPointer);
        RandomAccessInput startPointersSlice = this.indexInput.randomAccessSlice(this.startPointersStartPointer, this.startPointersEndPointer - this.startPointersStartPointer);
        this.docs = DirectMonotonicReader.getInstance(this.docsMeta, docsSlice);
        this.startPointers = DirectMonotonicReader.getInstance(this.startPointersMeta, startPointersSlice);
    }

    @Override
    public void close() throws IOException {
        this.indexInput.close();
    }

    @Override
    long getBlockID(int docID) {
        Objects.checkIndex(docID, this.maxDoc);
        long blockIndex = this.docs.binarySearch(0L, this.numChunks, docID);
        if (blockIndex < 0L) {
            blockIndex = -2L - blockIndex;
        }
        return blockIndex;
    }

    @Override
    long getBlockStartPointer(long blockIndex) {
        return this.startPointers.get(blockIndex);
    }

    @Override
    long getBlockLength(long blockIndex) {
        long endPointer = blockIndex == (long)(this.numChunks - 1) ? this.maxPointer : this.startPointers.get(blockIndex + 1L);
        return endPointer - this.getBlockStartPointer(blockIndex);
    }

    @Override
    public FieldsIndex clone() {
        try {
            return new FieldsIndexReader(this);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public long getMaxPointer() {
        return this.maxPointer;
    }

    @Override
    void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.indexInput);
    }
}

