/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.mixin.patch.entity;

import net.darkhax.bookshelf.common.api.data.BookshelfTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity
extends Entity {
    @Shadow
    protected int lastHurtByPlayerTime;
    @Shadow
    private int lastHurtByMobTimestamp;

    @Inject(method={"hurt"}, at={@At(value="HEAD")})
    private void updateFakePlayerDamageTimes(DamageSource source, float amount, CallbackInfoReturnable<Boolean> callback) {
        if (!this.level().isClientSide && !this.isInvulnerableTo(source) && source.is(BookshelfTags.FAKE_PLAYER_DAMAGE)) {
            this.lastHurtByPlayerTime = this.tickCount;
            this.lastHurtByMobTimestamp = this.tickCount;
        }
    }

    private MixinLivingEntity() {
        super(null, null);
    }
}

