/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createintegratedfarming.mixin.delightoflight;

import com.cloudmeow.delightoflight.registry.DFBlocks;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Restriction(require={@Condition(value="delighto_flight")})
@Mixin(value={LightningBolt.class})
public abstract class LightningBoltMixin
extends Entity {
    public LightningBoltMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    protected abstract BlockPos getStrikePosition();

    @Inject(method={"powerLightningRod"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/LightningRodBlock;onLightningStrike(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V", shift=At.Shift.AFTER)})
    private void injected(CallbackInfo ci) {
        BlockPos[] roll;
        BlockPos blockpos = this.getStrikePosition();
        BlockPos below = blockpos.below();
        for (BlockPos pos : roll = new BlockPos[]{below, below.east(), below.west(), below.north(), below.south()}) {
            BlockState state = this.level().getBlockState(pos);
            if (state.is(Blocks.DIRT) || state.is(Blocks.GRASS_BLOCK)) {
                this.level().setBlockAndUpdate(pos, ((Block)DFBlocks.WEATHER_SOIL.get()).defaultBlockState());
                continue;
            }
            if (!state.is(Blocks.DIRT_PATH) && !state.is(Blocks.FARMLAND)) continue;
            this.level().setBlockAndUpdate(pos, ((Block)DFBlocks.WEATHER_SOIL_FARMLAND.get()).defaultBlockState());
        }
    }
}

