/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createintegratedfarming.integration.farmersdelight.farming.harvest;

import com.simibubi.create.content.contraptions.actors.harvester.HarvesterMovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.BlockHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createintegratedfarming.api.harvester.CustomHarvestBehaviour;
import plus.dragons.createintegratedfarming.config.CIFConfig;
import vectorwing.farmersdelight.common.block.MushroomColonyBlock;

public class MushroomColonyHarvestBehaviour
implements CustomHarvestBehaviour {
    private final MushroomColonyBlock colony;
    private final Block mushroom;

    protected MushroomColonyHarvestBehaviour(MushroomColonyBlock colony, Block mushroom) {
        this.colony = colony;
        this.mushroom = mushroom;
    }

    @Nullable
    public static MushroomColonyHarvestBehaviour create(Block block) {
        if (!(block instanceof MushroomColonyBlock)) {
            return null;
        }
        MushroomColonyBlock colony = (MushroomColonyBlock)block;
        Object object = colony.mushroomType.value();
        if (!(object instanceof BlockItem)) {
            return null;
        }
        BlockItem mushroom = (BlockItem)object;
        if (BuiltInRegistries.BLOCK.getKey((Object)colony).getPath().contains("cloudshroom")) {
            return null;
        }
        return new MushroomColonyHarvestBehaviour(colony, mushroom.getBlock());
    }

    @Override
    public void harvest(HarvesterMovementBehaviour behaviour, MovementContext context, BlockPos pos, BlockState state) {
        if (((Boolean)CIFConfig.server().mushroomColoniesDropSelf.get()).booleanValue()) {
            this.harvestColony(behaviour, context, pos, state);
        } else {
            this.harvestMushroom(behaviour, context, pos, state);
        }
    }

    protected void harvestMushroom(HarvesterMovementBehaviour behaviour, MovementContext context, BlockPos pos, BlockState state) {
        int age = (Integer)state.getValue((Property)this.colony.getAgeProperty());
        if (age == 0) {
            return;
        }
        if (age < this.colony.getMaxAge() && !CustomHarvestBehaviour.partial()) {
            return;
        }
        Level level = context.world;
        level.playSound(null, pos, SoundEvents.MOOSHROOM_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)this.colony.getAgeProperty(), (Comparable)Integer.valueOf(0)));
        behaviour.dropItem(context, new ItemStack((ItemLike)this.mushroom, age));
    }

    protected void harvestColony(HarvesterMovementBehaviour behaviour, MovementContext context, BlockPos pos, BlockState state) {
        int age = (Integer)state.getValue((Property)this.colony.getAgeProperty());
        if (age < this.colony.getMaxAge() && !CustomHarvestBehaviour.partial()) {
            return;
        }
        BlockHelper.destroyBlockAs((Level)context.world, (BlockPos)pos, null, (ItemStack)CustomHarvestBehaviour.getHarvestTool(context, new ItemStack((ItemLike)Items.SHEARS)), (float)1.0f, stack -> behaviour.dropItem(context, stack));
        this.replantMushroom(context, pos);
    }

    protected void replantMushroom(MovementContext context, BlockPos pos) {
        if (!CustomHarvestBehaviour.replant()) {
            return;
        }
        Level level = context.world;
        BlockState newState = this.mushroom.defaultBlockState();
        if (!newState.canSurvive((LevelReader)level, pos)) {
            return;
        }
        ItemStack available = ItemHelper.extract((IItemHandler)context.contraption.getStorage().getAllItems(), stack -> stack.is(this.mushroom.asItem()), (int)1, (boolean)false);
        if (available.isEmpty()) {
            return;
        }
        level.setBlockAndUpdate(pos, newState);
    }
}

