/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createintegratedfarming.common.ranching.roost;

import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHandlerWrapper;
import com.simibubi.create.foundation.item.ItemHelper;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createintegratedfarming.config.CIFConfig;

public abstract class AnimalRoostBlockEntity
extends SmartBlockEntity {
    protected final ItemStackHandler inventory;
    public final IItemHandler outputHandler;
    protected int feedCooldown;
    protected int eggTime = this.productionCooldown();

    public int productionCooldown() {
        return 12000;
    }

    protected abstract ResourceKey<LootTable> productionLootTable();

    public AnimalRoostBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(20);
        this.inventory = new ItemStackHandler(this, (Integer)CIFConfig.server().roostingInventorySlotCount.get()){

            public int getSlotLimit(int slot) {
                return (Integer)CIFConfig.server().roostingInventorySlotSize.get();
            }
        };
        this.outputHandler = new ItemHandlerWrapper(this, (IItemHandlerModifiable)this.inventory){

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                return stack;
            }
        };
    }

    @Nullable
    public IItemHandler getItemHandler(@Nullable Direction direction) {
        if (direction == this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)) {
            return null;
        }
        return this.outputHandler;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this).onlyInsertWhen(side -> side == ((Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite()).considerOccupiedWhen(side -> this.feedCooldown > 0).setInsertionHandler(this::tryInsertFrom));
    }

    public void initialize() {
        assert (this.level != null);
        super.initialize();
        if (this.eggTime >= this.productionCooldown()) {
            this.eggTime = this.productionCooldown() / 2 + this.level.random.nextInt(this.productionCooldown() / 2);
        }
    }

    public void lazyTick() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        boolean changed = false;
        if (this.feedCooldown > 0) {
            this.feedCooldown = Math.max(0, this.feedCooldown - this.lazyTickRate);
            changed = true;
        }
        if (this.eggTime > 0) {
            this.eggTime = Math.max(0, this.eggTime - this.lazyTickRate);
            changed = true;
        }
        if (this.eggTime <= 0) {
            boolean inserted = false;
            LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(this.productionLootTable());
            LootParams lootParams = new LootParams.Builder(serverLevel).withParameter(LootContextParams.BLOCK_STATE, (Object)this.getBlockState()).withParameter(LootContextParams.ORIGIN, (Object)this.worldPosition.getCenter()).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)this).create(LootContextParamSets.BLOCK);
            ObjectArrayList lootStacks = lootTable.getRandomItems(lootParams);
            for (ItemStack stack : lootStacks) {
                ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)stack, (boolean)false);
                inserted |= stack.getCount() != remainder.getCount();
            }
            if (inserted) {
                this.eggTime = 6000 + this.level.random.nextInt(6000);
                this.level.playSound(null, this.worldPosition, SoundEvents.CHICKEN_EGG, SoundSource.BLOCKS, 1.0f, (this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.2f + 1.0f);
                changed = true;
            }
        }
        if (changed) {
            this.notifyUpdate();
        }
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        tag.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
        tag.putInt("EggLayTime", this.eggTime);
        tag.putInt("FeedCooldown", this.feedCooldown);
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.inventory.deserializeNBT(registries, tag.getCompound("Inventory"));
        this.eggTime = Math.clamp((long)tag.getInt("EggLayTime"), 0, 12000);
        this.feedCooldown = tag.getInt("FeedCooldown");
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.inventory);
    }

    protected ItemStack tryInsertFrom(TransportedItemStack transported, Direction side, boolean simulate) {
        assert (this.level != null);
        ItemStack stack = transported.stack.copy();
        if (this.feedItem(stack, simulate) && !simulate) {
            stack.shrink(1);
        }
        return stack;
    }

    public abstract boolean feedItem(ItemStack var1, boolean var2);
}

