/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.shops.loaders;

import com.benbenlaw.shops.loaders.ShopCatalog;
import com.benbenlaw.shops.loaders.ShopEntry;
import com.benbenlaw.shops.loaders.ShopRegistry;
import com.benbenlaw.shops.network.packets.SyncShopRegistryToClient;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.network.PacketDistributor;

public class CombinedShopLoader
extends SimpleJsonResourceReloadListener {
    private static final Map<ResourceLocation, ShopCatalog> LOADED_SHOPS = new HashMap<ResourceLocation, ShopCatalog>();

    public CombinedShopLoader(Gson gson, String directory) {
        super(gson, directory);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        ShopRegistry.clear();
        LOADED_SHOPS.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsonMap.entrySet()) {
            DataResult result = ShopCatalog.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue());
            result.result().ifPresent(shopCatalog -> {
                LOADED_SHOPS.put((ResourceLocation)entry.getKey(), (ShopCatalog)shopCatalog);
                for (ShopEntry item : shopCatalog.getEntries()) {
                    ShopRegistry.register(new ShopEntry(item.getItem(), item.getPrice(), item.getMode(), shopCatalog.getCatalogItem()));
                }
            });
            System.out.println("Loaded shop catalog: " + String.valueOf(entry.getKey()) + " with result: " + String.valueOf(result));
        }
    }

    public static void sendShopsPacketToPlayer(ServerPlayer player) {
        ArrayList<ShopEntry> allEntries = new ArrayList<ShopEntry>();
        for (ShopCatalog catalog : LOADED_SHOPS.values()) {
            for (ShopEntry item : catalog.getEntries()) {
                allEntries.add(new ShopEntry(item.getItem(), item.getPrice(), item.getMode(), catalog.getCatalogItem()));
            }
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncShopRegistryToClient(allEntries), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void loadEntry(JsonElement element) {
        DataResult result = ShopEntry.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
        result.result().ifPresent(ShopRegistry::register);
    }
}

