/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.shops.item;

import com.benbenlaw.shops.capability.PlayerBalanceData;
import com.benbenlaw.shops.capability.ShopsAttachments;
import com.benbenlaw.shops.network.packets.SyncPlayerBalanceToClient;
import com.benbenlaw.shops.sound.ShopsSounds;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class CoinItem
extends Item {
    int value;

    public CoinItem(Item.Properties properties, int value) {
        super(properties);
        this.value = value;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int p_41407_, boolean p_41408_) {
        if (!level.isClientSide() && entity instanceof Player) {
            Player player = (Player)entity;
            if (level.getGameTime() % 20L == 0L) {
                stack.shrink(1);
                int currentBalance = ((PlayerBalanceData)player.getData(ShopsAttachments.PLAYER_BALANCE)).getBalance();
                int newBalance = currentBalance + this.value;
                ((PlayerBalanceData)player.getData(ShopsAttachments.PLAYER_BALANCE)).setBalance(newBalance);
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new SyncPlayerBalanceToClient(newBalance), (CustomPacketPayload[])new CustomPacketPayload[0]);
                level.playSound(null, player.blockPosition(), ShopsSounds.COIN_COLLECTED.get(), player.getSoundSource(), 0.5f, 1.0f);
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            list.add((Component)Component.translatable((String)"tooltip.shops.value", (Object[])new Object[]{this.value}).withStyle(ChatFormatting.BLUE));
        } else {
            list.add((Component)Component.translatable((String)"tooltip.shops.shift").withStyle(ChatFormatting.YELLOW));
        }
    }
}

