/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.shops.integration.jei;

import com.benbenlaw.shops.block.ShopsBlocks;
import com.benbenlaw.shops.integration.jei.BuyingRecipeCategory;
import com.benbenlaw.shops.integration.jei.ItemSubtypeInterpreter;
import com.benbenlaw.shops.integration.jei.ItemSubtypeInterpreterCrate;
import com.benbenlaw.shops.integration.jei.SellingRecipeCategory;
import com.benbenlaw.shops.integration.jei.dummy.BuyingRecipe;
import com.benbenlaw.shops.integration.jei.dummy.SellingRecipe;
import com.benbenlaw.shops.item.ShopsItems;
import com.benbenlaw.shops.loaders.ShopEntry;
import com.benbenlaw.shops.loaders.ShopRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEIShopsPlugin
implements IModPlugin {
    public static final RecipeType<SellingRecipe> SELLING_RECIPE_TYPE = new RecipeType(SellingRecipeCategory.UID, SellingRecipe.class);
    public static final RecipeType<BuyingRecipe> BUYING_RECIPE_TYPE = new RecipeType(BuyingRecipeCategory.UID, BuyingRecipe.class);

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"shops", (String)"jei_plugin");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(ShopsItems.PINATA_FLARE.asItem(), (ISubtypeInterpreter)new ItemSubtypeInterpreter());
        registration.registerSubtypeInterpreter(ShopsItems.CRATE_FLARE.asItem(), (ISubtypeInterpreter)new ItemSubtypeInterpreterCrate());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((ItemLike)ShopsBlocks.SHOP.get(), new RecipeType[]{SELLING_RECIPE_TYPE});
        registration.addRecipeCatalyst((ItemLike)ShopsItems.COPPER_COIN.get(), new RecipeType[]{SELLING_RECIPE_TYPE});
        registration.addRecipeCatalyst((ItemLike)ShopsItems.IRON_COIN.get(), new RecipeType[]{SELLING_RECIPE_TYPE});
        registration.addRecipeCatalyst((ItemLike)ShopsItems.GOLD_COIN.get(), new RecipeType[]{SELLING_RECIPE_TYPE});
        registration.addRecipeCatalyst((ItemLike)ShopsItems.PLAYER_BALANCE_CARD.get(), new RecipeType[]{SELLING_RECIPE_TYPE});
        registration.addRecipeCatalyst((ItemLike)ShopsBlocks.SHOP.get(), new RecipeType[]{BUYING_RECIPE_TYPE});
        registration.addRecipeCatalyst((ItemLike)ShopsItems.COPPER_COIN.get(), new RecipeType[]{BUYING_RECIPE_TYPE});
        registration.addRecipeCatalyst((ItemLike)ShopsItems.IRON_COIN.get(), new RecipeType[]{BUYING_RECIPE_TYPE});
        registration.addRecipeCatalyst((ItemLike)ShopsItems.GOLD_COIN.get(), new RecipeType[]{BUYING_RECIPE_TYPE});
        registration.addRecipeCatalyst((ItemLike)ShopsItems.PLAYER_BALANCE_CARD.get(), new RecipeType[]{BUYING_RECIPE_TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new SellingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BuyingRecipeCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ArrayList<Integer> prices;
        ArrayList<ItemStack> inputs;
        ItemStack catalogueStack;
        Item catalogueItem;
        HashMap<Item, List> buyGroups = new HashMap<Item, List>();
        HashMap<Item, List> sellGroups = new HashMap<Item, List>();
        for (ShopEntry entry : ShopRegistry.getAllEntries()) {
            ItemStack catalogueStack2 = entry.getRequiredCatalogItem().copy();
            Item catalogueItem2 = catalogueStack2.getItem();
            if (entry.getMode() == ShopEntry.ShopMode.PLAYER_SELLS) {
                sellGroups.computeIfAbsent(catalogueItem2, k -> new ArrayList()).add(entry);
                continue;
            }
            if (entry.getMode() != ShopEntry.ShopMode.PLAYER_BUYS) continue;
            buyGroups.computeIfAbsent(catalogueItem2, k -> new ArrayList()).add(entry);
        }
        ArrayList<BuyingRecipe> buyingRecipes = new ArrayList<BuyingRecipe>();
        ArrayList<SellingRecipe> sellingRecipes = new ArrayList<SellingRecipe>();
        for (Map.Entry e : buyGroups.entrySet()) {
            catalogueItem = (Item)e.getKey();
            catalogueStack = new ItemStack((ItemLike)catalogueItem);
            inputs = new ArrayList<ItemStack>();
            prices = new ArrayList<Integer>();
            for (ShopEntry entry : (List)e.getValue()) {
                inputs.add(entry.getItem().copy());
                prices.add(entry.getPrice());
            }
            buyingRecipes.add(new BuyingRecipe(catalogueStack, inputs, prices));
        }
        for (Map.Entry e : sellGroups.entrySet()) {
            catalogueItem = (Item)e.getKey();
            catalogueStack = new ItemStack((ItemLike)catalogueItem);
            inputs = new ArrayList();
            prices = new ArrayList();
            for (ShopEntry entry : (List)e.getValue()) {
                inputs.add(entry.getItem().copy());
                prices.add(entry.getPrice());
            }
            sellingRecipes.add(new SellingRecipe(catalogueStack, inputs, prices));
        }
        registration.addRecipes(BUYING_RECIPE_TYPE, buyingRecipes);
        registration.addRecipes(SELLING_RECIPE_TYPE, sellingRecipes);
    }
}

