/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.shops.integration.jei;

import com.benbenlaw.shops.integration.jei.JEIShopsPlugin;
import com.benbenlaw.shops.integration.jei.dummy.BuyingRecipe;
import com.benbenlaw.shops.item.ShopsItems;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.widgets.IScrollGridWidgetFactory;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class BuyingRecipeCategory
implements IRecipeCategory<BuyingRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"shops", (String)"buying_recipe");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"shops", (String)"textures/gui/jei_buying.png");
    public final IDrawable background;
    public final IDrawable icon;
    private final IScrollGridWidgetFactory<?> scrollGridWidgetFactory;

    public BuyingRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 142, 37);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ShopsItems.GOLD_COIN.get()));
        this.scrollGridWidgetFactory = helper.createScrollGridFactory(5, 2);
        this.scrollGridWidgetFactory.setPosition(32, 0);
    }

    public RecipeType<BuyingRecipe> getRecipeType() {
        return JEIShopsPlugin.BUYING_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"jei.shops.buying");
    }

    @Nullable
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BuyingRecipe buyingRecipe, IFocusGroup iFocusGroup) {
        builder.addSlot(RecipeIngredientRole.CATALYST, 7, 11).addItemStack(buyingRecipe.catalog());
        for (ItemStack result : this.getInputs(buyingRecipe)) {
            int i = buyingRecipe.inputs().indexOf(result);
            ((IRecipeSlotBuilder)builder.addSlotToWidget(RecipeIngredientRole.OUTPUT, this.scrollGridWidgetFactory).addItemStack(buyingRecipe.inputs().get(i))).addRichTooltipCallback((slotView, tooltip) -> {
                int price = buyingRecipe.prices().get(i);
                tooltip.add((FormattedText)Component.translatable((String)"jei.shops.buying_price", (Object[])new Object[]{price}).withStyle(ChatFormatting.GOLD));
            });
        }
    }

    private List<ItemStack> getInputs(BuyingRecipe recipe) {
        return recipe.inputs();
    }
}

