/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.shops.entity;

import com.benbenlaw.shops.loaders.PinataData;
import com.benbenlaw.shops.loaders.PinataLoader;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class PinataEntity
extends AbstractHorse {
    private static final EntityDataAccessor<String> DATA_PINATA_TYPE = SynchedEntityData.defineId(PinataEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private ResourceLocation pinataType;
    private int hitCount = 0;
    private int requiredHits = -1;

    public PinataEntity(EntityType<? extends PinataEntity> type, Level level) {
        super(type, level);
        this.noPhysics = false;
        this.setHealth(10.0f);
    }

    public void tick() {
        super.tick();
        this.fallDistance = 0.0f;
        this.setDeltaMovement(0.0, this.getDeltaMovement().y, 0.0);
        this.xo = this.getX();
        this.yo = this.getY();
    }

    public void registerGoals() {
    }

    public boolean hurt(DamageSource source, float amount) {
        Level level = this.level();
        if (level.isClientSide) {
            return false;
        }
        Entity entity = source.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.getItemInHand(InteractionHand.MAIN_HAND).is(Tags.Items.RODS)) {
                ++this.hitCount;
                int requiredHits = this.getRequiredHits();
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.hitCount >= requiredHits) {
                    this.dropLootTable(serverLevel);
                    this.playSound(SoundEvents.FIREWORK_ROCKET_BLAST);
                    this.explodeFirework();
                    this.discard();
                } else {
                    this.playSound(Objects.requireNonNull(this.getHurtSound(source)), 1.0f, 1.0f);
                }
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.FIREWORK, this.getX(), this.getY() + 1.0, this.getZ(), 25, 0.2, 0.2, 0.2, 0.1);
                return true;
            }
            player.sendSystemMessage((Component)Component.translatable((String)"entity.shops.pinata_hit").withStyle(ChatFormatting.ITALIC));
        }
        return false;
    }

    private int getRequiredHits() {
        if (this.requiredHits == -1) {
            this.requiredHits = 3 + this.random.nextInt(5);
        }
        return this.requiredHits;
    }

    public boolean isPushable() {
        return false;
    }

    public void knockback(double strength, double x, double z) {
    }

    public Pose getPose() {
        return Pose.STANDING;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.FIREWORK_ROCKET_BLAST;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.FIREWORK_ROCKET_BLAST;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return null;
    }

    public boolean canEatGrass() {
        return false;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.pinataType != null) {
            tag.putString("PinataType", this.pinataType.toString());
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("PinataType")) {
            this.pinataType = ResourceLocation.parse((String)tag.getString("PinataType"));
            this.entityData.set(DATA_PINATA_TYPE, (Object)this.pinataType.toString());
        }
    }

    protected boolean canRide(Entity p_20339_) {
        return false;
    }

    private void explodeFirework() {
        int count = 1 + this.random.nextInt(5);
        IntArrayList colors = new IntArrayList();
        for (int i = 0; i < count; ++i) {
            int r = this.random.nextInt(256);
            int g = this.random.nextInt(256);
            int b = this.random.nextInt(256);
            colors.add(r << 16 | g << 8 | b);
        }
        int fadeCount = this.random.nextInt(4);
        IntArrayList fadeColors = new IntArrayList();
        for (int i = 0; i < fadeCount; ++i) {
            int r = this.random.nextInt(256);
            int g = this.random.nextInt(256);
            int b = this.random.nextInt(256);
            fadeColors.add(r << 16 | g << 8 | b);
        }
        FireworkExplosion.Shape shape = FireworkExplosion.Shape.values()[this.random.nextInt(FireworkExplosion.Shape.values().length)];
        FireworkExplosion explosion = new FireworkExplosion(shape, (IntList)colors, (IntList)fadeColors, true, true);
        Fireworks fireworks = new Fireworks(0, List.of(explosion));
        ItemStack rocket = new ItemStack((ItemLike)Items.FIREWORK_ROCKET);
        rocket.set(DataComponents.FIREWORKS, (Object)fireworks);
        FireworkRocketEntity entity = new FireworkRocketEntity(this.level(), this.getX(), this.getY() + 1.0, this.getZ(), rocket);
        this.level().addFreshEntity((Entity)entity);
    }

    public void setPinataType(ResourceLocation type) {
        this.pinataType = type;
        this.entityData.set(DATA_PINATA_TYPE, (Object)type.toString());
    }

    public ResourceLocation getPinataType() {
        String typeStr = (String)this.entityData.get(DATA_PINATA_TYPE);
        if (!typeStr.isEmpty()) {
            return ResourceLocation.tryParse((String)typeStr);
        }
        return this.pinataType;
    }

    private void dropLootTable(ServerLevel level) {
        PinataData data = PinataLoader.getPinata(this.pinataType);
        if (data != null) {
            ResourceLocation lootTable = data.lootTable();
            LootTable table = level.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)lootTable));
            LootParams lootParams = new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)this).create(LootContextParamSets.GIFT);
            ObjectArrayList loot = table.getRandomItems(lootParams);
            for (ItemStack stack : loot) {
                this.spawnAtLocation(stack);
            }
        }
    }

    public ResourceLocation getTexture() {
        PinataData data = PinataLoader.getPinata(this.getPinataType());
        if (data != null) {
            ResourceLocation model = data.model();
            return ResourceLocation.fromNamespaceAndPath((String)model.getNamespace(), (String)("textures/entity/pinata/" + model.getPath() + ".png"));
        }
        return ResourceLocation.fromNamespaceAndPath((String)"shops", (String)"textures/entity/pinata/default.png");
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_PINATA_TYPE, (Object)"");
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (!this.level().isClientSide() && hand == InteractionHand.MAIN_HAND) {
            player.sendSystemMessage((Component)Component.translatable((String)"entity.shops.pinata_interact").withStyle(ChatFormatting.RED));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }
}

