/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.util;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.compat.SlotlessableItemHandlerWrapper;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public final class StackUtil {
    public static boolean canAddAll(ItemStackHandlerAA inv, List<ItemStack> stacks, boolean fromAutomation) {
        int counter = 0;
        ItemStackHandlerAA dummy = StackUtil.testDummy(inv, 0, inv.getSlots());
        for (ItemStack s : stacks) {
            for (int i = 0; i < dummy.getSlots() && !(s = dummy.insertItem(i, s, false, fromAutomation)).isEmpty(); ++i) {
            }
            if (!s.isEmpty()) continue;
            ++counter;
        }
        return counter == stacks.size();
    }

    public static void addAll(ItemStackHandlerAA inv, List<ItemStack> stacks, boolean fromAutomation) {
        int slotMax = inv.getSlots();
        for (ItemStack s : stacks) {
            for (int i = 0; i < slotMax && !(s = inv.insertItem(i, s, false, fromAutomation)).isEmpty(); ++i) {
            }
        }
    }

    public static boolean canAddAll(ItemStackHandlerAA inv, List<ItemStack> stacks, int slot, int endSlot, boolean fromAutomation) {
        int counter = 0;
        ItemStackHandlerAA dummy = StackUtil.testDummy(inv, slot, endSlot);
        for (ItemStack s : stacks) {
            for (int i = 0; i < dummy.getSlots() && !(s = dummy.insertItem(i, s, false, fromAutomation)).isEmpty(); ++i) {
            }
            if (!s.isEmpty()) continue;
            ++counter;
        }
        return counter == stacks.size();
    }

    public static void addAll(ItemStackHandlerAA inv, List<ItemStack> stacks, int slot, int endSlot, boolean fromAutomation) {
        for (ItemStack s : stacks) {
            for (int i = slot; i < endSlot && !(s = inv.insertItem(i, s, false, fromAutomation)).isEmpty(); ++i) {
            }
        }
    }

    public static int findFirstFilled(IItemHandler inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (inv.getStackInSlot(i).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack grow(ItemStack s, int i) {
        s.grow(i);
        return s;
    }

    public static ItemStack shrink(ItemStack s, int i) {
        s.shrink(i);
        return s;
    }

    public static ItemStack shrinkForContainer(ItemStack s, int i) {
        ItemStack sc = s.copy();
        s.shrink(i);
        if (s.isEmpty()) {
            return sc.getItem().getCraftingRemainingItem(sc);
        }
        return s;
    }

    public static ItemStack insertItem(SlotlessableItemHandlerWrapper wrapper, ItemStack stack, boolean simulate, int slotStart, int slotEnd) {
        IItemHandler normalHandler;
        if (stack.isEmpty()) {
            return stack;
        }
        if (ActuallyAdditions.commonCapsLoaded) {
            // empty if block
        }
        if ((normalHandler = wrapper.getNormalHandler()) != null) {
            ItemStack remain = stack.copy();
            for (int i = Math.max(0, slotStart); i < Math.min(slotEnd, normalHandler.getSlots()); ++i) {
                remain = normalHandler.insertItem(i, remain, simulate);
            }
            return remain;
        }
        return stack;
    }

    public static ItemStackHandlerAA testDummy(ItemStackHandlerAA inv, int slot, int endSlot) {
        NonNullList stacks = NonNullList.withSize((int)(endSlot - slot), (Object)ItemStack.EMPTY);
        for (int i = slot; i < endSlot; ++i) {
            stacks.set(i - slot, (Object)inv.getStackInSlot(i).copy());
        }
        return new ItemStackHandlerAA((NonNullList<ItemStack>)stacks, inv.getAcceptor(), inv.getRemover());
    }
}

