/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import de.ellpeck.actuallyadditions.mod.inventory.gui.FluidDisplay;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public class FermentingRecipe
implements Recipe<RecipeInput> {
    public static final String NAME = "fermenting";
    private final FluidStack input;
    private final FluidStack output;
    private final int time;
    private Optional<FluidDisplay> inputDisplay;
    private Optional<FluidDisplay> outputDisplay;

    public FermentingRecipe(FluidStack input, FluidStack output, int timeIn) {
        this.input = input;
        this.output = output;
        this.time = timeIn;
    }

    public boolean matches(FluidStack stack) {
        return FluidStack.isSameFluidSameComponents((FluidStack)stack, (FluidStack)this.input);
    }

    public boolean matches(FluidStack input, FluidStack output) {
        return FluidStack.isSameFluidSameComponents((FluidStack)input, (FluidStack)this.input) && (output.isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)output, (FluidStack)this.output) && input.getAmount() >= this.input.getAmount());
    }

    public Optional<FluidDisplay> getInputDisplay() {
        return this.inputDisplay;
    }

    public void setInputDisplay(FluidDisplay inputDisplay) {
        this.inputDisplay = Optional.of(inputDisplay);
    }

    public Optional<FluidDisplay> getOutputDisplay() {
        return this.outputDisplay;
    }

    public void setOutputDisplay(FluidDisplay outputDisplay) {
        this.outputDisplay = Optional.of(outputDisplay);
    }

    public int getTime() {
        return this.time;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public FluidStack getInput() {
        return this.input;
    }

    public boolean matches(RecipeInput pInv, Level pLevel) {
        return false;
    }

    public boolean isSpecial() {
        return true;
    }

    @Nonnull
    public ItemStack assemble(RecipeInput pInv, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return false;
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return ActuallyRecipes.FERMENTING_RECIPE.get();
    }

    @Nonnull
    public RecipeType<?> getType() {
        return ActuallyRecipes.Types.FERMENTING.get();
    }

    public static class Serializer
    implements RecipeSerializer<FermentingRecipe> {
        private static final MapCodec<FermentingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FluidStack.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.input), (App)FluidStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.output), (App)Codec.INT.fieldOf("time").forGetter(recipe -> recipe.time)).apply((Applicative)instance, FermentingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FermentingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<FermentingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FermentingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        @Nullable
        public static FermentingRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf pBuffer) {
            FluidStack input = (FluidStack)FluidStack.STREAM_CODEC.decode((Object)pBuffer);
            FluidStack output = (FluidStack)FluidStack.STREAM_CODEC.decode((Object)pBuffer);
            int time = pBuffer.readInt();
            return new FermentingRecipe(input, output, time);
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf pBuffer, @Nonnull FermentingRecipe pRecipe) {
            FluidStack.STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.input);
            FluidStack.STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.output);
            pBuffer.writeInt(pRecipe.time);
        }
    }
}

