/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.recipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ItemExistsCondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.OrCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRecipeBuilder<R extends Recipe<?>, B extends BaseRecipeBuilder<R, ?>>
implements Consumer<RecipeOutput> {
    @Nullable
    protected final String directory;
    protected final List<ICondition> conditions = new ArrayList<ICondition>();
    @Nullable
    protected ResourceLocation id;

    protected BaseRecipeBuilder(@Nullable String directory) {
        this.directory = directory;
    }

    protected abstract B builder();

    public abstract RecipeHolder<R> build();

    @Nullable
    public AdvancementHolder buildAdvancement() {
        return null;
    }

    @Nullable
    public String getDirectory() {
        return this.directory;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public final void accept(RecipeOutput output) {
        RecipeHolder<R> holder = this.build();
        ResourceLocation id = this.directory == null ? holder.id() : holder.id().withPrefix(this.directory + "/");
        ICondition[] conditions = (ICondition[])this.conditions.toArray(ICondition[]::new);
        output.accept(id, holder.value(), this.buildAdvancement(), conditions);
    }

    public B withId(ResourceLocation id) {
        this.id = id;
        return this.builder();
    }

    public B withCondition(ICondition condition) {
        this.conditions.add(condition);
        return this.builder();
    }

    public final B withoutCondition(ICondition condition) {
        this.conditions.add((ICondition)new NotCondition(condition));
        return this.builder();
    }

    public final B withAllCondition(ICondition ... conditions) {
        Collections.addAll(this.conditions, conditions);
        return this.builder();
    }

    public final B withAnyCondition(ICondition ... conditions) {
        this.conditions.add((ICondition)new OrCondition(List.of(conditions)));
        return this.builder();
    }

    public final B withMod(String mod) {
        this.withCondition((ICondition)new ModLoadedCondition(mod));
        return this.builder();
    }

    public final B withoutMod(String mod) {
        this.withoutCondition((ICondition)new ModLoadedCondition(mod));
        return this.builder();
    }

    public final B withItem(ResourceLocation location) {
        this.withCondition((ICondition)new ItemExistsCondition(location));
        return this.builder();
    }

    public final B withItem(DeferredHolder<Item, ?> item) {
        this.withCondition((ICondition)new ItemExistsCondition(item.getId()));
        return this.builder();
    }

    public final B withoutItem(ResourceLocation location) {
        this.withoutCondition((ICondition)new ItemExistsCondition(location));
        return this.builder();
    }

    public final B withoutItem(DeferredHolder<Item, ?> item) {
        this.withoutCondition((ICondition)new ItemExistsCondition(item.getId()));
        return this.builder();
    }

    public final B withTag(ResourceLocation location) {
        this.withoutCondition((ICondition)new TagEmptyCondition(location));
        return this.builder();
    }

    public final B withTag(TagKey<Item> tag) {
        this.withoutCondition((ICondition)new TagEmptyCondition(tag));
        return this.builder();
    }

    public final B withoutTag(ResourceLocation location) {
        this.withCondition((ICondition)new TagEmptyCondition(location));
        return this.builder();
    }

    public final B withoutTag(TagKey<Item> tag) {
        this.withCondition((ICondition)new TagEmptyCondition(tag));
        return this.builder();
    }
}

