/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.rainshield.handler;

import com.mrbysco.rainshield.network.payloads.SyncShieldMapPayload;
import com.mrbysco.rainshield.util.RainShieldData;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class SyncHandler {
    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!player.level().isClientSide) {
            SyncHandler.syncShieldMap((ServerPlayer)player);
        }
    }

    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player.level().isClientSide) {
            RainShieldData.rainShieldMap.clear();
        }
    }

    public static void syncShieldMap(ServerPlayer player) {
        RainShieldData rainShieldData = RainShieldData.get((Level)player.getServer().getLevel(Level.OVERWORLD));
        CompoundTag tag = rainShieldData.save(new CompoundTag(), (HolderLookup.Provider)player.registryAccess());
        player.connection.send((CustomPacketPayload)new SyncShieldMapPayload(tag));
    }
}

