/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.trinkets.wrapper;

import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import io.wispforest.accessories_compat.trinkets.pond.CosmeticLookupTogglable;
import io.wispforest.accessories_compat.trinkets.wrapper.WrappedSlotType;
import java.util.Collection;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;

public class WrappedTrinketInventory
extends TrinketInventory {
    public final AccessoriesContainer container;

    public WrappedTrinketInventory(TrinketComponent component, AccessoriesContainer container, SlotType slotType) {
        super((dev.emi.trinkets.api.SlotType)WrappedSlotType.of(slotType, container.capability().entity().level().isClientSide()), component, trinketInventory -> {});
        this.container = container;
    }

    public SlotType getAccessoreisSlotType() {
        return ((WrappedSlotType)this.getSlotType()).slotType;
    }

    public void setOtherGroupName(String value) {
        ((WrappedSlotType)this.getSlotType()).setOtherGroupName(value);
    }

    public Map<ResourceLocation, AttributeModifier> getModifiers() {
        return this.container.getModifiers();
    }

    public Collection<AttributeModifier> getModifiersByOperation(AttributeModifier.Operation operation) {
        return this.container.getModifiersForOperation(operation);
    }

    public void addModifier(AttributeModifier modifier) {
        this.container.addTransientModifier(modifier);
    }

    public void addPersistentModifier(AttributeModifier modifier) {
        this.container.addPersistentModifier(modifier);
    }

    public void removeModifier(ResourceLocation location) {
        this.container.removeModifier(location);
    }

    public void clearModifiers() {
        this.container.clearModifiers();
    }

    public void removeCachedModifier(AttributeModifier attributeModifier) {
        this.container.getCachedModifiers().remove(attributeModifier);
    }

    public void clearCachedModifiers() {
        this.container.clearCachedModifiers();
    }

    public void markUpdate() {
        this.container.markChanged(false);
    }

    public void clearContent() {
        ExpandedSimpleContainer accessories = this.container.getAccessories();
        ExpandedSimpleContainer cosmetics = this.container.getCosmeticAccessories();
        for (int i = 0; i < accessories.getContainerSize(); ++i) {
            accessories.setItem(i, ItemStack.EMPTY);
            cosmetics.setItem(i, ItemStack.EMPTY);
        }
        this.markUpdate();
    }

    public int getContainerSize() {
        return this.container.getAccessories().getContainerSize();
    }

    public boolean isEmpty() {
        return this.container.getAccessories().getContainerSize() != 0;
    }

    public ItemStack getItem(int slot) {
        CosmeticLookupTogglable lookup;
        LivingEntity livingEntity = this.container.capability().entity();
        if (livingEntity instanceof CosmeticLookupTogglable && (lookup = (CosmeticLookupTogglable)livingEntity).accessories$getLookupToggle()) {
            if (!this.container.shouldRender(slot)) {
                return ItemStack.EMPTY;
            }
            ItemStack accessoryStack = this.container.getCosmeticAccessories().getItem(slot);
            if (accessoryStack.isEmpty()) {
                accessoryStack = this.container.getAccessories().getItem(slot);
            }
            return accessoryStack;
        }
        return this.container.getAccessories().getItem(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        return this.container.getAccessories().removeItem(slot, amount);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        ExpandedSimpleContainer stacks = this.container.getAccessories();
        ItemStack itemStack = stacks.getItem(slot);
        stacks.setItem(slot, ItemStack.EMPTY);
        return itemStack;
    }

    public void setItem(int slot, ItemStack stack) {
        this.container.getAccessories().setItem(slot, stack);
    }
}

