/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.trinkets;

import com.google.common.collect.BiMap;
import com.mojang.datafixers.util.Either;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketEnums;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.TrinketsAttributeModifiersComponent;
import dev.emi.trinkets.data.EntitySlotLoader;
import dev.emi.trinkets.data.SlotLoader;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories_compat.AccessoriesCompatInit;
import io.wispforest.accessories_compat.api.EntityBindingModifier;
import io.wispforest.accessories_compat.api.ModCompatibilityModule;
import io.wispforest.accessories_compat.api.ReloadListenerRegisterCallback;
import io.wispforest.accessories_compat.api.tags.CollectionAddition;
import io.wispforest.accessories_compat.api.tags.SlotTypesModifier;
import io.wispforest.accessories_compat.trinkets.mixin.accessor.GroupDataAccessor;
import io.wispforest.accessories_compat.trinkets.mixin.accessor.SlotDataAccessor;
import io.wispforest.accessories_compat.trinkets.mixin.accessor.SlotLoaderAccessor;
import io.wispforest.accessories_compat.trinkets.utils.SlotIdRedirect;
import io.wispforest.accessories_compat.trinkets.wrapper.AccessoryFromTrinket;
import io.wispforest.accessories_compat.trinkets.wrapper.TrinketFromAccessory;
import io.wispforest.accessories_compat.trinkets.wrapper.TrinketsWrappingUtils;
import io.wispforest.accessories_compat.utils.LoaderPlatformUtils;
import it.unimi.dsi.fastutil.Pair;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.SequencedSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class TrinketsCompat
extends ModCompatibilityModule {
    public static final TrinketsCompat INSTANCE = TrinketsCompat.create();
    private final ResourceLocation EMPTY_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"trinkets", (String)"gui/slots/empty.png");

    protected TrinketsCompat() {
        super("trinkets");
    }

    @Nullable
    private static TrinketsCompat create() {
        if (!LoaderPlatformUtils.INSTANCE.isModLoaded("trinkets")) {
            AccessoriesCompatInit.LOGGER.error("Attempted to load the TrinketsCompat while Trinkets the mod is not loaded!");
            return null;
        }
        return new TrinketsCompat();
    }

    @Override
    public void registerDataLoaders(ReloadListenerRegisterCallback callback) {
        callback.registerSlotLoader((PreparableReloadListener)SlotLoader.INSTANCE, SlotLoader.INSTANCE.getFabricId());
        callback.registerEntitySlotLoader((PreparableReloadListener)EntitySlotLoader.SERVER, EntitySlotLoader.SERVER.getFabricId());
    }

    @Override
    public void addEntityBindings(EntityBindingModifier modifier) {
        Map<String, Pair<String, Integer>> redirects = SlotIdRedirect.getMap(AccessoriesCompatInit.CONFIG.slotIdRedirects());
        for (Map.Entry<EntityType<?>, Map<String, Set<String>>> entry : TrinketsWrappingUtils.CURRENT_SLOT_INFO.entrySet()) {
            CollectionAddition<String> addition = modifier.addTo(entry.getKey());
            Map<String, Set<String>> groupedSlots = entry.getValue();
            for (Map.Entry<String, Set<String>> groupEntry : groupedSlots.entrySet()) {
                String groupName = groupEntry.getKey();
                for (String slotName : groupEntry.getValue()) {
                    Pair<String, Integer> redirect = redirects.get(groupName + "/" + slotName);
                    String accessoryType = redirect != null ? (String)redirect.key() : TrinketsWrappingUtils.trinketsToAccessories_Slot(Optional.of(groupName), slotName);
                    addition.add(accessoryType);
                }
            }
        }
        TrinketsWrappingUtils.CURRENT_SLOT_INFO.clear();
    }

    @Override
    public void addSlotTypes(SlotTypesModifier modifier) {
        Map<String, Pair<String, Integer>> redirects = SlotIdRedirect.getMap(AccessoriesCompatInit.CONFIG.slotIdRedirects());
        for (Map.Entry<String, GroupDataAccessor> groupDataEntry : ((SlotLoaderAccessor)SlotLoader.INSTANCE).getLoadedSlots().entrySet()) {
            String groupName = groupDataEntry.getKey();
            GroupDataAccessor groupData = groupDataEntry.getValue();
            Map<String, SlotDataAccessor> slots = groupData.getSlots();
            for (Map.Entry<String, SlotDataAccessor> entry : slots.entrySet()) {
                Pair<String, Integer> redirect = redirects.get(groupName + "/" + entry.getKey());
                String accessoryType = redirect != null ? (String)redirect.key() : TrinketsWrappingUtils.trinketsToAccessories_Slot(Optional.of(groupName), entry.getKey());
                SlotDataAccessor slotData = entry.getValue();
                SlotTypeLoader.SlotBuilder builder = modifier.getBuilder(accessoryType);
                if (builder != null) {
                    Integer slotsCurrentSize = builder.baseAmount;
                    if (slotsCurrentSize != null && slotData.getAmount() > slotsCurrentSize) {
                        builder.amount(slotData.getAmount());
                    }
                    if (redirect != null) {
                        builder.addAmount(((Integer)redirect.right()).intValue());
                    }
                } else {
                    builder = modifier.addBuilder(accessoryType);
                    if (slotData.getAmount() != -1) {
                        builder.amount(slotData.getAmount());
                    }
                    builder.order(Integer.valueOf(slotData.getOrder()));
                    ResourceLocation icon = ResourceLocation.parse((String)slotData.getIcon());
                    if (!icon.equals((Object)this.EMPTY_TEXTURE)) {
                        builder.icon(icon);
                    }
                    builder.dropRule(TrinketsWrappingUtils.convertDropRule(TrinketEnums.DropRule.valueOf((String)slotData.getDropRule())));
                    builder.alternativeTranslation("trinkets.slot." + groupDataEntry.getKey() + "." + entry.getKey());
                }
                for (String validatorPredicate : slotData.getValidatorPredicates()) {
                    ResourceLocation location = ResourceLocation.tryParse((String)validatorPredicate);
                    if (location == null) continue;
                    builder.validator(TrinketsWrappingUtils.trinketsToAccessories_Validators(location));
                }
            }
        }
    }

    @Override
    public SequencedSet<ResourceLocation> toAccessoriesTag(ResourceLocation tag) {
        BiMap<String, String> redirects = SlotIdRedirect.getBiMap(AccessoriesCompatInit.CONFIG.slotIdRedirects());
        String path = tag.getPath();
        String[] parts = path.split("/");
        if (parts.length != 2) {
            return new LinkedHashSet<ResourceLocation>();
        }
        String group = parts[0];
        String slot = parts[1];
        return (SequencedSet)Either.unwrap((Either)TrinketsWrappingUtils.trinketsToAccessories_SlotEither(Optional.of(group), slot).mapRight(slotName -> new LinkedHashSet<ResourceLocation>(Set.of(ResourceLocation.fromNamespaceAndPath((String)"accessories", (String)slotName)))).mapLeft(slotName -> {
            LinkedHashSet<ResourceLocation> entries = new LinkedHashSet<ResourceLocation>();
            String redirect = (String)redirects.get((Object)tag.getPath());
            if (redirect != null) {
                entries.add(ResourceLocation.fromNamespaceAndPath((String)"accessories", (String)redirect));
            }
            entries.add(ResourceLocation.fromNamespaceAndPath((String)"accessories", (String)slotName));
            return entries;
        }));
    }

    @Override
    public SequencedSet<ResourceLocation> fromAccessoriesTag(ResourceLocation tag) {
        LinkedHashSet<ResourceLocation> entries = new LinkedHashSet<ResourceLocation>();
        SequencedCollection<String> possibleGroups = TrinketsWrappingUtils.getGroupFromDefaultSlot(tag.getPath());
        for (String group : possibleGroups) {
            entries.add(ResourceLocation.fromNamespaceAndPath((String)"trinkets", (String)(group + "/" + TrinketsWrappingUtils.accessoriesToTrinkets_Slot(tag.getPath()))));
        }
        return entries;
    }

    @Override
    public void getAttributes(ItemStack stack, @Nullable LivingEntity entity, String accessoriesSlotName, int slot, AccessoryAttributeBuilder builder) {
        if (!stack.has(TrinketsAttributeModifiersComponent.TYPE)) {
            return;
        }
        for (TrinketsAttributeModifiersComponent.Entry entry : ((TrinketsAttributeModifiersComponent)stack.getOrDefault(TrinketsAttributeModifiersComponent.TYPE, (Object)TrinketsAttributeModifiersComponent.DEFAULT)).modifiers()) {
            if (entry.slot().isEmpty()) {
                builder.addExclusive(entry.attribute(), entry.modifier());
                continue;
            }
            if (entity == null) continue;
            SlotGroup group = TrinketsWrappingUtils.getGroup(entity.level(), accessoriesSlotName);
            String slotId = TrinketsWrappingUtils.accessoriesToTrinkets_Group(group.name()) + "/" + TrinketsWrappingUtils.accessoriesToTrinkets_Slot(accessoriesSlotName);
            if (!((String)entry.slot().get()).equals(slotId)) continue;
            builder.addExclusive(entry.attribute(), entry.modifier());
        }
    }

    @Override
    public boolean skipOnEquipCheck(ItemStack stack, Accessory accessory) {
        return accessory instanceof AccessoryFromTrinket;
    }

    @Override
    public boolean skipDefaultRenderer(Item item) {
        Trinket trinket = TrinketsApi.getTrinket((Item)item);
        return trinket != TrinketsApi.getDefaultTrinket() && !(trinket instanceof TrinketFromAccessory);
    }
}

