/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.curios;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories_compat.AccessoriesCompatInit;
import io.wispforest.accessories_compat.api.EntityBindingModifier;
import io.wispforest.accessories_compat.api.ModCompatibilityModule;
import io.wispforest.accessories_compat.api.ReloadListenerRegisterCallback;
import io.wispforest.accessories_compat.api.tags.CollectionAddition;
import io.wispforest.accessories_compat.api.tags.SlotTypesModifier;
import io.wispforest.accessories_compat.curios.mixin.accessor.ItemizedCurioCapabilityAccessor;
import io.wispforest.accessories_compat.curios.mixin.accessor.SlotTypeBuilderAccessor;
import io.wispforest.accessories_compat.curios.wrapper.AccessoryFromCurio;
import io.wispforest.accessories_compat.curios.wrapper.CuriosConversionUtils;
import io.wispforest.accessories_compat.utils.LoaderPlatformUtils;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.SequencedSet;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CurioAttributeModifiers;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.common.CuriosRegistry;
import top.theillusivec4.curios.common.data.CuriosEntityManager;
import top.theillusivec4.curios.common.data.CuriosSlotManager;

public class CuriosCompat
extends ModCompatibilityModule {
    public static final CuriosCompat INSTANCE = CuriosCompat.create();
    private final ResourceLocation EMPTY_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"curios", (String)"slot/empty_curio_slot");

    protected CuriosCompat() {
        super("curios");
    }

    @Nullable
    private static CuriosCompat create() {
        if (!LoaderPlatformUtils.INSTANCE.isModLoaded("curios")) {
            AccessoriesCompatInit.LOGGER.error("Attempted to load the CuriosCompat while Curios the mod is not loaded!");
            return null;
        }
        return new CuriosCompat();
    }

    @Override
    public void registerDataLoaders(ReloadListenerRegisterCallback callback) {
        callback.registerSlotLoader((PreparableReloadListener)CuriosSlotManager.SERVER, ResourceLocation.fromNamespaceAndPath((String)"accessories_compat_layer", (String)"curios_slot_manager"));
        callback.registerEntitySlotLoader((PreparableReloadListener)CuriosEntityManager.SERVER, ResourceLocation.fromNamespaceAndPath((String)"accessories_compat_layer", (String)"curios_entity_manager"));
    }

    @Override
    public void addEntityBindings(EntityBindingModifier modifier) {
        for (Map.Entry<EntityType<?>, ImmutableMap.Builder<String, ISlotType>> entry : CuriosConversionUtils.CURRENT_ENTITY_BINDINGS.entrySet()) {
            CollectionAddition<String> addition = modifier.addTo(entry.getKey());
            for (String curiosId : entry.getValue().buildKeepingLast().keySet()) {
                String accessoriesId = CuriosConversionUtils.slotConvertToA(curiosId);
                addition.add(accessoriesId);
            }
        }
    }

    @Override
    public void addSlotTypes(SlotTypesModifier modifier) {
        CuriosConversionUtils.CURRENT_SLOT_BUILDERS.forEach((curiosId, curiosBuilder) -> {
            SlotTypeBuilderAccessor accessor = (SlotTypeBuilderAccessor)curiosBuilder;
            String accessoriesId = CuriosConversionUtils.slotConvertToA(curiosId);
            SlotTypeLoader.SlotBuilder builder = modifier.getBuilder(accessoriesId);
            Integer slotsCurrentSize = null;
            if (builder != null) {
                slotsCurrentSize = builder.baseAmount;
            } else {
                builder = modifier.addBuilder(accessoriesId);
                ResourceLocation icon = accessor.getIcon();
                if (icon != null && !icon.equals((Object)this.EMPTY_TEXTURE)) {
                    builder.icon(icon);
                }
                if (accessor.getOrder() != null) {
                    builder.order(accessor.getOrder());
                }
                if (accessor.getDropRule() != null) {
                    builder.dropRule(CuriosConversionUtils.dropRuleConvertToA(accessor.getDropRule()));
                }
                builder.alternativeTranslation("curios.identifier." + curiosId);
            }
            if (!(accessor.getSize() == null || slotsCurrentSize == null || AccessoriesCompatInit.defaultSlots.contains(accessoriesId) && accessor.getSize() <= slotsCurrentSize)) {
                builder.amount(accessor.getSize().intValue());
            }
            if (accessor.getSizeMod() != 0) {
                builder.addAmount(accessor.getSizeMod());
            }
            if (accessor.getValidators() != null) {
                for (ResourceLocation validatorPredicate : accessor.getValidators()) {
                    builder.validator(CuriosConversionUtils.convertToA(validatorPredicate));
                }
            }
        });
        CuriosConversionUtils.CURRENT_SLOT_BUILDERS.clear();
    }

    @Override
    public SequencedSet<ResourceLocation> toAccessoriesTag(ResourceLocation moduleSlotTag) {
        return new LinkedHashSet<ResourceLocation>(Set.of(ResourceLocation.fromNamespaceAndPath((String)"accessories", (String)CuriosConversionUtils.slotConvertToA(moduleSlotTag.getPath()))));
    }

    @Override
    public SequencedSet<ResourceLocation> fromAccessoriesTag(ResourceLocation accessoriesSlotTag) {
        return new LinkedHashSet<ResourceLocation>(Set.of(ResourceLocation.fromNamespaceAndPath((String)"curios", (String)CuriosConversionUtils.slotConvertToC(accessoriesSlotTag.getPath()))));
    }

    @Override
    public void getAttributes(ItemStack stack, @Nullable LivingEntity entity, String accessoriesSlotName, int slot, AccessoryAttributeBuilder builder) {
        LinkedHashMultimap multimap = LinkedHashMultimap.create();
        if (!stack.has((DataComponentType)CuriosRegistry.CURIO_ATTRIBUTE_MODIFIERS.get())) {
            return;
        }
        for (CurioAttributeModifiers.Entry entry : ((CurioAttributeModifiers)stack.getOrDefault((DataComponentType)CuriosRegistry.CURIO_ATTRIBUTE_MODIFIERS.get(), (Object)CurioAttributeModifiers.EMPTY)).modifiers()) {
            ResourceLocation rl;
            String targetSlot = entry.slot();
            if (!targetSlot.equals(CuriosConversionUtils.slotConvertToC(accessoriesSlotName)) && !targetSlot.isBlank() || (rl = entry.attribute()) == null) continue;
            AttributeModifier attributeModifier = entry.modifier();
            AttributeModifier.Operation operation = attributeModifier.operation();
            double amount = attributeModifier.amount();
            ResourceLocation id = attributeModifier.id();
            if (rl.getNamespace().equals("curios")) {
                boolean clientSide;
                String attributeSlotName = rl.getPath();
                if (!CuriosApi.getSlot((String)attributeSlotName, (boolean)(clientSide = entity == null || entity.level().isClientSide())).isPresent()) continue;
                CuriosApi.addSlotModifier((Multimap)multimap, (String)attributeSlotName, (ResourceLocation)id, (double)amount, (AttributeModifier.Operation)operation);
                continue;
            }
            BuiltInRegistries.ATTRIBUTE.getHolder(rl).ifPresent(arg_0 -> CuriosCompat.lambda$getAttributes$1((Multimap)multimap, id, amount, operation, arg_0));
        }
        multimap.forEach((arg_0, arg_1) -> ((AccessoryAttributeBuilder)builder).addExclusive(arg_0, arg_1));
    }

    @Override
    public boolean skipOnEquipCheck(ItemStack stack, Accessory accessory) {
        return accessory instanceof AccessoryFromCurio;
    }

    @Override
    public boolean skipDefaultRenderer(Item item) {
        ItemizedCurioCapabilityAccessor accessor;
        ICurio iCurioItem = CuriosApi.getCurio((ItemStack)item.getDefaultInstance()).orElse(null);
        return !(iCurioItem instanceof ItemizedCurioCapabilityAccessor && (accessor = (ItemizedCurioCapabilityAccessor)iCurioItem).getCurioItem() instanceof AccessoryFromCurio);
    }

    private static /* synthetic */ void lambda$getAttributes$1(Multimap multimap, ResourceLocation id, double amount, AttributeModifier.Operation operation, Holder.Reference attribute) {
        multimap.put((Object)attribute, (Object)new AttributeModifier(id, amount, operation));
    }
}

