/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.common;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.wispforest.accessories_compat.api.ModCompatibilityModule;
import io.wispforest.accessories_compat.api.tags.LoadedTagData;
import io.wispforest.accessories_compat.api.tags.RuntimeTagModifier;
import io.wispforest.accessories_compat.api.tags.TagManipulationData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagLoader;

public class TagModificationLogic {
    public static void modify(Map<ResourceLocation, List<TagLoader.EntryWithSource>> map) {
        Map<String, ModCompatibilityModule> modules = ModCompatibilityModule.getModules();
        if (modules.isEmpty()) {
            return;
        }
        HashMap<ModCompatibilityModule, TagManipulationData> modulesManipulationData = new HashMap<ModCompatibilityModule, TagManipulationData>();
        for (ModCompatibilityModule module2 : modules.values()) {
            modulesManipulationData.put(module2, new TagManipulationData((Multimap<ResourceLocation, ResourceLocation>)HashMultimap.create(), new HashMap<ResourceLocation, LoadedTagData>()));
        }
        TagManipulationData accessoryManipulationData = new TagManipulationData((Multimap<ResourceLocation, ResourceLocation>)HashMultimap.create(), new HashMap<ResourceLocation, LoadedTagData>());
        map.forEach((location, entries) -> {
            block4: {
                ArrayList<TagLoader.EntryWithSource> entriesCopy;
                block3: {
                    ModCompatibilityModule possibleModule = (ModCompatibilityModule)modules.get(location.getNamespace());
                    entriesCopy = new ArrayList<TagLoader.EntryWithSource>((Collection<TagLoader.EntryWithSource>)entries);
                    if (possibleModule == null) break block3;
                    ResourceLocation moduleTag = location;
                    TagManipulationData manipulationData = (TagManipulationData)modulesManipulationData.get(possibleModule);
                    for (ResourceLocation accessoryTag : possibleModule.toAccessoriesTag(moduleTag)) {
                        accessoryManipulationData.tagMappings().put((Object)moduleTag, (Object)accessoryTag);
                        manipulationData.tagMappings().put((Object)accessoryTag, (Object)moduleTag);
                        manipulationData.tagHolders().put(moduleTag, new LoadedTagData(moduleTag, entriesCopy));
                    }
                    break block4;
                }
                if (!location.getNamespace().equals("accessories")) break block4;
                ResourceLocation accessoryTag = location;
                for (ModCompatibilityModule module : modules.values()) {
                    TagManipulationData manipulationData = (TagManipulationData)modulesManipulationData.get(module);
                    for (ResourceLocation moduleTag : module.fromAccessoriesTag(accessoryTag)) {
                        accessoryManipulationData.tagMappings().put((Object)moduleTag, (Object)accessoryTag);
                        manipulationData.tagMappings().put((Object)accessoryTag, (Object)moduleTag);
                        accessoryManipulationData.tagHolders().put(accessoryTag, new LoadedTagData(accessoryTag, entriesCopy));
                    }
                }
            }
        });
        RuntimeTagModifier lookup = RuntimeTagModifier.from(map);
        LinkedHashSet allAccessoryTags = new LinkedHashSet();
        HashMap moduleToTags = new HashMap();
        modulesManipulationData.forEach((module, data) -> {
            allAccessoryTags.addAll(data.tagMappings().keySet());
            allAccessoryTags.addAll(accessoryManipulationData.tagMappings().values());
            moduleToTags.computeIfAbsent(module, $ -> new ArrayList()).addAll(data.tagHolders().values());
        });
        RuntimeTagModifier.LOGGER.info("All Tags to be dealt with: {}", allAccessoryTags);
        for (ResourceLocation resourceLocation : allAccessoryTags) {
            ArrayList<LoadedTagData> otherModulesTagData = new ArrayList<LoadedTagData>();
            LoadedTagData accessoriesTagData = accessoryManipulationData.tagHolders().computeIfAbsent(resourceLocation, LoadedTagData::new);
            RuntimeTagModifier.TagAddition accessoryTagModification = lookup.addTo(accessoriesTagData);
            for (TagManipulationData maps : modulesManipulationData.values()) {
                Map<ResourceLocation, LoadedTagData> moduleTags = maps.tagHolders();
                for (ResourceLocation moduleLocation : maps.tagMappings().get((Object)resourceLocation)) {
                    LoadedTagData moduleTagData = moduleTags.computeIfAbsent(moduleLocation, LoadedTagData::new);
                    RuntimeTagModifier.TagAddition moduleTagModification = lookup.addTo(moduleTagData);
                    accessoryTagModification.from(moduleTagData);
                    moduleTagModification.from(accessoriesTagData);
                    for (LoadedTagData otherModuleTagData : otherModulesTagData) {
                        moduleTagModification.from(otherModuleTagData);
                        lookup.addTo(otherModuleTagData).from(moduleTagData);
                    }
                    otherModulesTagData.add(moduleTagData);
                }
            }
        }
        lookup = RuntimeTagModifier.from(map, false);
        for (Map.Entry entry : moduleToTags.entrySet()) {
            RuntimeTagModifier.TagAddition tagAddition = lookup.addTo(((ModCompatibilityModule)entry.getKey()).getAllItemTag());
            ((List)entry.getValue()).forEach(tagAddition::from);
        }
    }
}

