/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.api.tags;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories_compat.api.tags.CollectionAddition;
import io.wispforest.accessories_compat.api.tags.LoadedTagData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagLoader;
import org.slf4j.Logger;

public interface RuntimeTagModifier {
    public static final Logger LOGGER = LogUtils.getLogger();

    public static RuntimeTagModifier from(Map<ResourceLocation, List<TagLoader.EntryWithSource>> tagEntries) {
        return RuntimeTagModifier.from(tagEntries, true);
    }

    public static RuntimeTagModifier from(Map<ResourceLocation, List<TagLoader.EntryWithSource>> tagEntries, final boolean shouldLogAdditions) {
        return toLocation -> {
            final List list = tagEntries.computeIfAbsent(toLocation, $ -> new ArrayList());
            return fromLocation -> new CollectionAddition<TagLoader.EntryWithSource>(){

                @Override
                public void add(TagLoader.EntryWithSource t) {
                    if (shouldLogAdditions) {
                        LOGGER.warn("[RuntimeTagModification] Adding Entry from [{}] to [{}]: \n     {}", new Object[]{fromLocation, toLocation, t});
                    }
                    list.add(t);
                }

                @Override
                public void add(Collection<TagLoader.EntryWithSource> collection) {
                    if (collection.isEmpty()) {
                        return;
                    }
                    if (shouldLogAdditions) {
                        LOGGER.warn("[RuntimeTagModification] Adding Entries from [{}] to [{}]: \n     {}", new Object[]{fromLocation, toLocation, collection});
                    }
                    list.addAll(collection);
                }
            };
        };
    }

    default public TagAddition addTo(LoadedTagData data) {
        return this.addTo(data.tagKey());
    }

    public TagAddition addTo(ResourceLocation var1);

    public static interface TagAddition {
        public CollectionAddition from(ResourceLocation var1);

        default public void from(LoadedTagData data) {
            this.from(data.tagKey()).add(data.entries());
        }
    }
}

