/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat;

import com.google.common.reflect.Reflection;
import io.wispforest.accessories_compat.common.AccessoriesCompatConfig;
import io.wispforest.accessories_compat.curios.CuriosCompat;
import io.wispforest.accessories_compat.trinkets.TrinketsCompat;
import io.wispforest.accessories_compat.utils.LoaderPlatformUtils;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessoriesCompatInit {
    public static final String MODID = "accessories_compat_layer";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"accessories_compat_layer");
    public static final AccessoriesCompatConfig CONFIG = AccessoriesCompatConfig.createAndLoad();
    public static final Set<String> defaultSlots = Set.of("anklet", "back", "belt", "cape", "charm", "face", "hand", "hat", "necklace", "ring", "shoes", "wrist");
    public static final boolean DEBUG;

    public static void init() {
        LOGGER.info("Setting up compat modules for Accessories!");
        if (LoaderPlatformUtils.INSTANCE.isModLoaded("trinkets")) {
            Reflection.initialize((Class[])new Class[]{TrinketsCompat.class});
        }
        if (LoaderPlatformUtils.INSTANCE.isModLoaded("curios")) {
            Reflection.initialize((Class[])new Class[]{CuriosCompat.class});
        }
    }

    @ApiStatus.Internal
    public static void debugWarn(Logger logger, String message) {
        if (!DEBUG) {
            return;
        }
        logger.warn(message);
    }

    @ApiStatus.Internal
    public static void debugWarn(Logger logger, String message, Object ... params) {
        if (!DEBUG) {
            return;
        }
        logger.warn(message, params);
    }

    public static void ifDebugging(Runnable runnable) {
        if (!DEBUG) {
            return;
        }
        runnable.run();
    }

    static {
        boolean debug = LoaderPlatformUtils.INSTANCE.isDevelopmentEnvironment();
        if (System.getProperty("accessories_compat_layer.debug") != null) {
            debug = Boolean.getBoolean("accessories_compat_layer.debug");
        }
        DEBUG = debug;
    }
}

