/*
 * Decompiled with CFR 0.152.
 */
package me.frankv.jmi.jmdefaultconfig;

import java.io.File;
import java.io.IOException;
import lombok.Generated;
import me.frankv.jmi.JMI;
import me.frankv.jmi.util.FileHelper;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMDefaultConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JMDefaultConfig.class);
    private final Version existVersion;
    private final FileHelper<Version> fileHelper = new FileHelper<Version>("/journeymap/defaultconfig.json", Version.class);

    public JMDefaultConfig() {
        if (!this.fileHelper.getFile().exists()) {
            this.fileHelper.write(new Version(-1));
        }
        this.existVersion = this.fileHelper.read();
    }

    public void tryWriteJMDefaultConfig() {
        Integer version = JMI.getClientConfig().getDefaultConfigVersion();
        if (version >= 0 && this.existVersion.version() < version) {
            this.writeJMDefaultConfig(version);
        }
    }

    private void writeJMDefaultConfig(int newVersion) {
        File source = new File(System.getProperty("user.dir") + "/config/jmdefaultconfig");
        File dest = new File(System.getProperty("user.dir") + "/journeymap/");
        if (!source.exists() || !source.isDirectory()) {
            log.warn("No default config found.");
            return;
        }
        log.info("Writing default configs for Journeymap...");
        try {
            this.fileHelper.write(new Version(newVersion));
            FileUtils.copyDirectory((File)source, (File)dest);
            log.info("Journeymap configs updated.");
        }
        catch (IOException e) {
            log.error("Failed to write default configs " + String.valueOf(e));
        }
    }

    private record Version(int version) {
    }
}

